/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.svg2vector.applications.is;

import de.vandermeer.execs.options.ApplicationOption;
import de.vandermeer.svg2vector.applications.base.AppBase;
import de.vandermeer.svg2vector.applications.base.AppProperties;
import de.vandermeer.svg2vector.applications.base.SvgTargets;
import de.vandermeer.svg2vector.applications.is.AO_ExportDpi;
import de.vandermeer.svg2vector.applications.is.AO_ExportPdfVersion;
import de.vandermeer.svg2vector.applications.is.AO_ExportPsLevel;
import de.vandermeer.svg2vector.applications.is.AO_InkscapeExecutable;
import de.vandermeer.svg2vector.applications.is.AO_ManualLayers;
import de.vandermeer.svg2vector.applications.is.AO_SvgFirst;
import de.vandermeer.svg2vector.applications.is.IsCmd;
import de.vandermeer.svg2vector.applications.is.IsLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Svg2Vector_IS
extends AppBase<IsLoader, AppProperties<IsLoader>> {
    public static final String APP_NAME = "s2v-is";
    public static final String APP_DISPLAY_NAME = "Svg2Vector Inkscape";
    public static final String APP_VERSION = "v2.0.0 build 170413 (13-Apr-17) for Java 1.8";
    public static final String TMP_FN_PREFIX = "s2vis-";
    AO_InkscapeExecutable optionInkscapeExec = new AO_InkscapeExecutable(Character.valueOf('x'));
    AO_ExportDpi optionExpDpi = new AO_ExportDpi(SvgTargets.png, "--export-dpi");
    AO_ExportPsLevel optionExpPslevel = new AO_ExportPsLevel(SvgTargets.ps, "--export-ps-level");
    AO_ExportPdfVersion optionExpPdfver = new AO_ExportPdfVersion(SvgTargets.pdf, "--export-pdf-version");
    AO_SvgFirst optionSvgFirst = new AO_SvgFirst(false, Character.valueOf('g'), "requires the tool to generate temporary SVG files first and then us those files to generate the actual target");
    AO_ManualLayers optionManualLayers = new AO_ManualLayers(false, Character.valueOf('m'), "layers are switched off/on on a raw text file, i.e. not using any SVG or XML library");
    Path tmpDir;
    Path tmpFile;

    public Svg2Vector_IS() {
        super(new AppProperties<IsLoader>(SvgTargets.values(), new IsLoader()));
        this.addOption((ApplicationOption<?>)this.optionExpDpi);
        this.addOption((ApplicationOption<?>)this.optionExpPdfver);
        this.addOption((ApplicationOption<?>)this.optionExpPslevel);
        this.addOption((ApplicationOption<?>)this.optionSvgFirst);
        this.addOption((ApplicationOption<?>)this.optionManualLayers);
        this.addOption((ApplicationOption<?>)this.optionInkscapeExec);
    }

    private int checkIsExecutable(String fn) {
        if (StringUtils.isBlank((CharSequence)fn)) {
            this.printErrorMessage("expected Inkscape executable, found <" + fn + ">");
            return -20;
        }
        File testFD = new File(fn);
        if (!testFD.exists()) {
            this.printErrorMessage("Inkscape executable <" + fn + "> does not exist, please check path and filename");
            return -21;
        }
        if (!testFD.isFile()) {
            this.printErrorMessage("Inkscape executable <" + fn + "> is not a file, please check path and filename");
            return -22;
        }
        if (!testFD.canExecute()) {
            this.printErrorMessage("cannot execute input Inkscape executable <" + fn + ">, please file permissions");
            return -23;
        }
        return 0;
    }

    private int convertInput(IsCmd isCmd, SvgTargets target) {
        int ret = 0;
        if (this.optionSvgFirst.inCli() && ((AppProperties)this.getProps()).doesLayers()) {
            this.printProgressMessage("converting multiple temporary SVG files");
            if (((AppProperties)this.getProps()).canWriteFiles()) {
                if (this.tmpDir == null && ((AppProperties)this.getProps()).canWriteFiles()) {
                    this.printErrorMessage("implementation error: expected tmp dir to exist, but was null");
                    return -92;
                }
                for (File fileEntry : this.tmpDir.toFile().listFiles()) {
                    if (!fileEntry.isFile()) continue;
                    String finTmp = this.tmpDir + "/" + fileEntry.getName();
                    String fout = ((AppProperties)this.getProps()).getDout() + "/" + StringUtils.substringBefore((String)fileEntry.getName(), (String)".svg") + "." + target.name();
                    this.ExecInkscape(isCmd, finTmp, fout);
                }
            } else {
                this.printDetailMessage("would create target files, 1 per layer now, from temporary files");
            }
        } else if (this.optionSvgFirst.inCli()) {
            this.printProgressMessage("converting single temporary SVG file");
            if (this.tmpFile == null && ((AppProperties)this.getProps()).canWriteFiles()) {
                this.printErrorMessage("implementation error: expected tmp file to exist, but was null");
                return -93;
            }
            this.ExecInkscape(isCmd, ((AppProperties)this.getProps()).canWriteFiles() ? this.tmpFile.toString() : TMP_FN_PREFIX, ((AppProperties)this.getProps()).getFoutFn());
        } else if (((AppProperties)this.getProps()).doesLayers()) {
            for (Map.Entry<String, Integer> entry : ((IsLoader)((AppProperties)this.getProps()).getLoader()).getLayers().entrySet()) {
                String fout = ((AppProperties)this.getProps()).getFnOut(entry) + "." + target.name();
                String nodeId = "layer" + entry.getValue().toString();
                IsCmd nodeCmd = new IsCmd(isCmd);
                nodeCmd.appendSelectedNode(nodeId);
                this.ExecInkscape(nodeCmd, ((AppProperties)this.getProps()).getFinFn(), fout);
                if (ret >= 0) continue;
                return ret;
            }
        } else {
            this.ExecInkscape(isCmd, ((AppProperties)this.getProps()).getFinFn(), ((AppProperties)this.getProps()).getFoutFn());
        }
        return ret;
    }

    private int createTempArtifacts(IsCmd isTmpCmd) {
        int ret = 0;
        IsLoader loader = (IsLoader)((AppProperties)this.getProps()).getLoader();
        if (this.optionSvgFirst.inCli()) {
            if (((AppProperties)this.getProps()).doesLayers()) {
                this.printProgressMessage("creating temporary directory");
                if (((AppProperties)this.getProps()).canWriteFiles()) {
                    try {
                        this.tmpDir = Files.createTempDirectory(TMP_FN_PREFIX, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.printErrorMessage("problem creating temporary directory with error: " + e.getMessage());
                        return -90;
                    }
                    this.printDetailMessage("temp directory:   " + this.tmpDir);
                } else {
                    this.printDetailMessage("temp dir prefix:  s2vis-");
                }
                this.printProgressMessage("creating temporary SVG files");
                if (this.optionManualLayers.inCli()) {
                    this.printDetailMessage("using manual layer handling");
                    for (Map.Entry<String, Integer> entry : loader.getLayers().entrySet()) {
                        loader.switchOffAllLayers();
                        loader.switchOnLayer(entry.getKey());
                        String err = this.write((((AppProperties)this.getProps()).canWriteFiles() ? this.tmpDir.toString() : TMP_FN_PREFIX) + "/" + ((AppProperties)this.getProps()).getFnOutNoDir(entry) + ".svg", loader.getLines());
                        if (err == null) continue;
                        this.printErrorMessage(err);
                        return -92;
                    }
                } else {
                    this.printDetailMessage("using Inkscape for layer handling");
                    for (Map.Entry<String, Integer> entry : loader.getLayers().entrySet()) {
                        String fout = this.tmpDir.toString() + "/" + ((AppProperties)this.getProps()).getFnOutNoDir(entry) + ".svg";
                        String nodeId = "layer" + entry.getValue().toString();
                        IsCmd nodeCmd = new IsCmd(isTmpCmd);
                        nodeCmd.appendSelectedNode(nodeId);
                        ret = this.ExecInkscape(nodeCmd, ((AppProperties)this.getProps()).getFinFn(), fout);
                        if (ret >= 0) continue;
                        return ret;
                    }
                }
            } else {
                this.printProgressMessage("creating temporary file");
                if (((AppProperties)this.getProps()).canWriteFiles()) {
                    try {
                        this.tmpFile = Files.createTempFile(TMP_FN_PREFIX, null, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.printErrorMessage("problem creating temporary file with error: " + e.getMessage());
                        return -91;
                    }
                    this.printDetailMessage("temp file:        " + this.tmpFile);
                } else {
                    this.printDetailMessage("temp file prefix: s2vis-");
                }
                ret = this.ExecInkscape(isTmpCmd, ((AppProperties)this.getProps()).getFinFn(), ((AppProperties)this.getProps()).canWriteFiles() ? this.tmpFile.toString() : TMP_FN_PREFIX);
                if (ret < 0) {
                    return ret;
                }
            }
        }
        return ret;
    }

    public int ExecInkscape(IsCmd cmd, String fin, String fout) {
        String cli = cmd.substitute(fin, fout);
        if (((AppProperties)this.getProps()).canWriteFiles()) {
            try {
                Process p = Runtime.getRuntime().exec(cli);
                p.waitFor();
            }
            catch (IOException e) {
                this.printErrorMessage("IO exception while executing Inkscape with error: " + e.getMessage());
                return -110;
            }
            catch (InterruptedException e) {
                this.printErrorMessage("InterruptedException exception while executing Inkscape with error: " + e.getMessage());
                return -111;
            }
        }
        this.printDetailMessage("");
        this.printDetailMessage("running IS for input <" + fin + "> creating output <" + fout + ">");
        this.printDetailMessage("running IS with cli <" + cli + ">");
        this.printDetailMessage("");
        return 0;
    }

    @Override
    public int executeApplication(String[] args) {
        int ret = super.executeApplication(args);
        if (ret != 0) {
            return ret;
        }
        SvgTargets target = ((AppProperties)this.getProps()).getTarget();
        String fn = (String)this.optionInkscapeExec.getValue();
        ret = this.checkIsExecutable(fn);
        if (ret < 0) {
            return ret;
        }
        this.printDetailMessage("Inkscape exec:    " + fn);
        this.setWarnings(target);
        IsCmd isCmd = new IsCmd(fn, target, (AppProperties<?>)this.getProps());
        isCmd.appendTargetSettings(target, this.optionExpDpi, this.optionExpPdfver, this.optionExpPslevel);
        IsCmd isTmpCmd = new IsCmd(fn, SvgTargets.svg, (AppProperties<?>)this.getProps());
        if (this.optionSvgFirst.inCli()) {
            this.printProgressMessage("converting to temporary SVG first");
            this.printDetailMessage("Inkscape cmd tmp: " + isTmpCmd);
        } else {
            this.printProgressMessage("converting directly to target");
            this.printDetailMessage("Inkscape cmd:     " + isCmd);
        }
        ret = this.createTempArtifacts(isTmpCmd);
        if (ret < 0) {
            return ret;
        }
        ret = this.convertInput(isCmd, target);
        if (ret < 0) {
            return ret;
        }
        this.removeTempArtifacts();
        this.printProgressMessage("finished successfully");
        return 0;
    }

    public String getAppDescription() {
        return "Converts SVG graphics into other vector formats using Inkscape, with options for handling layers";
    }

    public String getAppDisplayName() {
        return APP_DISPLAY_NAME;
    }

    public String getAppName() {
        return APP_NAME;
    }

    public String getAppVersion() {
        return APP_VERSION;
    }

    private void removeTempArtifacts() {
        if (!((AppProperties)this.getProps()).doesKeepTempArtifacts()) {
            this.printProgressMessage("removing temporary artifacts");
            if (this.tmpDir != null) {
                for (File fileEntry : this.tmpDir.toFile().listFiles()) {
                    fileEntry.delete();
                }
                this.tmpDir.toFile().delete();
            }
            if (this.tmpFile != null) {
                this.tmpFile.toFile().delete();
            }
        }
    }

    private void setWarnings(SvgTargets target) {
        Validate.notNull((Object)((Object)target));
        if (target != SvgTargets.pdf && this.optionExpPdfver.inCli()) {
            ((AppProperties)this.getProps()).getWarnings().add("target is not <pdf> but CLI option <" + this.optionExpPdfver.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        if (target != SvgTargets.png && this.optionExpDpi.inCli()) {
            ((AppProperties)this.getProps()).getWarnings().add("target is not <png> but CLI option <" + this.optionExpDpi.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        if (target != SvgTargets.ps && this.optionExpPslevel.inCli()) {
            ((AppProperties)this.getProps()).getWarnings().add("target is not <ps> but CLI option <" + this.optionExpPslevel.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        if (!this.optionSvgFirst.inCli() && this.optionManualLayers.inCli()) {
            ((AppProperties)this.getProps()).getWarnings().add("found CLI option <" + this.optionManualLayers.getCliOption().getLongOpt() + "> but not <" + this.optionSvgFirst.getCliOption().getLongOpt() + ">, option will be ignored");
        }
        if (((AppProperties)this.getProps()).doesLayers()) {
            // empty if block
        }
        if (((AppProperties)this.getProps()).doesNoLayers() && this.optionManualLayers.inCli()) {
            ((AppProperties)this.getProps()).getWarnings().add("no layers processed but CLI option <" + this.optionManualLayers.getCliOption().getLongOpt() + "> used, will be ignored");
        }
        this.printWarnings();
    }

    public String write(String fn, ArrayList<String> lines) {
        if (StringUtils.isBlank((CharSequence)fn)) {
            return "write: file name was blank";
        }
        if (lines == null) {
            return "write: lines was null";
        }
        if (lines.size() == 0) {
            return "write: size of lines was 0";
        }
        if (((AppProperties)this.getProps()).canWriteFiles()) {
            FileWriter writer;
            try {
                writer = new FileWriter(fn);
            }
            catch (IOException e) {
                return "IO error creating file writer: " + e.getMessage();
            }
            try {
                for (String str : lines) {
                    writer.write(str);
                }
                writer.close();
            }
            catch (IOException e) {
                return "IO error writing to file <" + fn + "> or closing writer: " + e.getMessage();
            }
        }
        this.printDetailMessage("temporary file: " + fn);
        return null;
    }
}

