/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.gemsloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jruby.RubyInstanceConfig;

public class GemLoader {
    public RubyInstanceConfig configWithGems() throws IOException {
        RubyInstanceConfig config = new RubyInstanceConfig();
        List<String> loadPaths = this.loadPaths();
        config.setLoadPaths(loadPaths);
        return config;
    }

    public List<String> loadPaths() throws IOException {
        ArrayList<String> loadPaths = new ArrayList<String>();
        Enumeration<URL> gemDefinitions = this.classLoader().getResources("gems-in-jar/gems-in-jar.properties");
        while (gemDefinitions.hasMoreElements()) {
            Properties gemsProperties = new Properties();
            URL gemDefinitionsUrl = gemDefinitions.nextElement();
            gemsProperties.load(gemDefinitionsUrl.openStream());
            Enumeration<?> gems = gemsProperties.propertyNames();
            while (gems.hasMoreElements()) {
                String gemPath = gemsProperties.getProperty((String)gems.nextElement());
                loadPaths.add(this.classLoader().getResource("gems/" + gemPath + "/lib").getPath());
            }
        }
        return loadPaths;
    }

    private ClassLoader classLoader() {
        return this.getClass().getClassLoader();
    }
}

