/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.autoconfigure.mail.javamail.concurrent;

import de.vinado.boot.autoconfigure.mail.javamail.concurrent.ConcurrentSenderProperties;
import de.vinado.spring.mail.javamail.concurrent.ConcurrentJavaMailSender;
import de.vinado.spring.mail.javamail.concurrent.ConcurrentJavaMailSenderFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JavaMailSender.class})
@EnableConfigurationProperties(value={MailProperties.class, ConcurrentSenderProperties.class})
public class ConcurrentSenderAutoConfiguration {
    @Bean(value={"mailSender"})
    @ConditionalOnProperty(prefix="javamail.concurrent", name={"enabled"}, havingValue="true")
    @ConditionalOnMissingClass(value={"net.markenwerk.utils.mail.dkim.DkimSigner"})
    ConcurrentJavaMailSender concurrentJavaMailSender(MailProperties mailProperties, ConcurrentSenderProperties concurrentSenderProperties) {
        JavaMailSenderImpl delegate = this.mailSender(mailProperties);
        return this.mailSender(concurrentSenderProperties, (JavaMailSender)delegate);
    }

    JavaMailSenderImpl mailSender(MailProperties properties) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        this.applyProperties(properties, sender);
        return sender;
    }

    ConcurrentJavaMailSender mailSender(ConcurrentSenderProperties concurrentSenderProperties, JavaMailSender delegate) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ConcurrentJavaMailSenderFactory concurrentSenderFactory = new ConcurrentJavaMailSenderFactory(executor);
        ConcurrentJavaMailSender concurrentJavaMailSender = concurrentSenderFactory.decorate(delegate);
        this.applyProperties(concurrentSenderProperties, concurrentJavaMailSender);
        return concurrentJavaMailSender;
    }

    private void applyProperties(MailProperties properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        sender.setProtocol(properties.getProtocol());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (!properties.getProperties().isEmpty()) {
            sender.setJavaMailProperties(this.asProperties(properties.getProperties()));
        }
    }

    private void applyProperties(ConcurrentSenderProperties properties, ConcurrentJavaMailSender sender) {
        sender.setBatchSize(properties.getBatchSize());
        sender.setCooldownMillis(properties.getCooldownMillis());
    }

    private Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }
}

