/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.boot.autoconfigure.mail.javamail.dkim;

import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="javamail.dkim")
public class DkimSignerProperties {
    private String signingDomain;
    private String selector;
    private Resource privateKey;
    private SignerProperties signer = new SignerProperties();

    public String getSigningDomain() {
        return this.signingDomain;
    }

    public String getSelector() {
        return this.selector;
    }

    public Resource getPrivateKey() {
        return this.privateKey;
    }

    public SignerProperties getSigner() {
        return this.signer;
    }

    public void setSigningDomain(String signingDomain) {
        this.signingDomain = signingDomain;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setSigner(SignerProperties signer) {
        this.signer = signer;
    }

    public static class SignerProperties {
        private String identity = null;
        private Canonicalization headerCanonicalization = Canonicalization.SIMPLE;
        private Canonicalization bodyCanonicalization = Canonicalization.RELAXED;
        private boolean checkDomainKey = true;
        private SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256_WITH_RSA;
        private boolean lengthParam = true;
        private boolean copyHeaderFields = false;

        public String getIdentity() {
            return StringUtils.hasText((String)this.identity) ? this.identity : null;
        }

        public Canonicalization getHeaderCanonicalization() {
            return this.headerCanonicalization;
        }

        public Canonicalization getBodyCanonicalization() {
            return this.bodyCanonicalization;
        }

        public boolean isCheckDomainKey() {
            return this.checkDomainKey;
        }

        public SigningAlgorithm getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public boolean isLengthParam() {
            return this.lengthParam;
        }

        public boolean isCopyHeaderFields() {
            return this.copyHeaderFields;
        }

        public void setIdentity(String identity) {
            this.identity = identity;
        }

        public void setHeaderCanonicalization(Canonicalization headerCanonicalization) {
            this.headerCanonicalization = headerCanonicalization;
        }

        public void setBodyCanonicalization(Canonicalization bodyCanonicalization) {
            this.bodyCanonicalization = bodyCanonicalization;
        }

        public void setCheckDomainKey(boolean checkDomainKey) {
            this.checkDomainKey = checkDomainKey;
        }

        public void setSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public void setLengthParam(boolean lengthParam) {
            this.lengthParam = lengthParam;
        }

        public void setCopyHeaderFields(boolean copyHeaderFields) {
            this.copyHeaderFields = copyHeaderFields;
        }
    }
}

