/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.spring.mail.javamail.dkim;

import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMailMessage;

public class DkimJavaMailSender
extends JavaMailSenderImpl {
    private final DkimSigner signer;

    public DkimJavaMailSender(DkimSigner signer) {
        this.signer = signer;
    }

    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(simpleMessages.length);
        for (SimpleMailMessage simpleMessage : simpleMessages) {
            MimeMailMessage message = new MimeMailMessage(this.createMimeMessage());
            simpleMessage.copyTo((MailMessage)message);
            mimeMessages.add(this.createSignedMimeMessage(message.getMimeMessage()));
        }
        this.doSend(mimeMessages.toArray(new MimeMessage[0]), simpleMessages);
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        MimeMessage[] signedMessages = (MimeMessage[])Arrays.stream(mimeMessages).map(this::createSignedMimeMessage).toArray(MimeMessage[]::new);
        super.send(signedMessages);
    }

    public MimeMessage createSignedMimeMessage(MimeMessage message) throws MailException {
        try {
            return new DkimMessage(message, this.signer);
        }
        catch (MessagingException e) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)e);
        }
    }
}

