/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.spring.mail.javamail;

import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.Assert;

public abstract class JavaMailSenderDecorator
implements JavaMailSender {
    private final JavaMailSender delegate;

    public JavaMailSenderDecorator(JavaMailSender delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate JavaMailSender must not be null");
        this.delegate = delegate;
    }

    public MimeMessage createMimeMessage() {
        return this.delegate.createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.delegate.createMimeMessage(contentStream);
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.delegate.send(mimeMessage);
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        this.delegate.send(mimeMessages);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.delegate.send(mimeMessagePreparator);
    }

    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        this.delegate.send(mimeMessagePreparators);
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.delegate.send(simpleMessage);
    }

    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        this.delegate.send(simpleMessages);
    }

    public JavaMailSender getDelegate() {
        return this.delegate;
    }
}

