/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.spring.mail.javamail.concurrent;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class Batch
implements Delayed {
    private static final Logger log = LoggerFactory.getLogger(Batch.class);
    private final long time;
    private final Object[] messages;
    private final Derivate derivate;

    protected Batch(long time, Object[] messages) {
        this.time = time;
        this.messages = messages;
        this.derivate = Derivate.forClass(messages.getClass());
    }

    void dispatch(JavaMailSender sender) {
        this.derivate.send(sender, this.messages);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long diff = this.time - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        return Batch.saturatedCast(this.time - ((Batch)other).time);
    }

    private static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public String toString() {
        return new StringJoiner(", ", Batch.class.getSimpleName() + "[", "]").add("time=" + Instant.ofEpochMilli(this.time).atZone(ZoneId.systemDefault()).toLocalDateTime()).add("delay=" + this.getDelay(TimeUnit.MILLISECONDS) + "ms").add("messages=" + Arrays.toString(this.messages)).add("derivate=" + (Object)((Object)this.derivate)).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Batch)) {
            return false;
        }
        Batch other = (Batch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMessages(), other.getMessages())) {
            return false;
        }
        Derivate this$derivate = this.derivate;
        Derivate other$derivate = other.derivate;
        return !(this$derivate == null ? other$derivate != null : !((Object)((Object)this$derivate)).equals((Object)other$derivate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Batch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.time;
        result = result * 59 + (int)($time >>> 32 ^ $time);
        result = result * 59 + Arrays.deepHashCode(this.getMessages());
        Derivate $derivate = this.derivate;
        result = result * 59 + ($derivate == null ? 43 : ((Object)((Object)$derivate)).hashCode());
        return result;
    }

    Object[] getMessages() {
        return this.messages;
    }

    private static enum Derivate {
        SIMPLE_MAIL_MESSAGE(SimpleMailMessage[].class, (sender, messages) -> sender.send((SimpleMailMessage[])messages)),
        MIME_MESSAGE(MimeMessage[].class, (sender, messages) -> sender.send((MimeMessage[])messages)),
        MIME_MESSAGE_PREPARATOR(MimeMessagePreparator[].class, (sender, messages) -> sender.send((MimeMessagePreparator[])messages));

        private final Class<?> messageType;
        private final BiConsumer<JavaMailSender, Object[]> dispatcher;

        private void send(JavaMailSender sender, Object[] messages) {
            this.dispatcher.accept(sender, messages);
            if (log.isDebugEnabled()) {
                log.debug("Dispatched using {}", (Object)sender);
            }
        }

        private static Derivate forClass(Class<?> messageType) {
            return Arrays.stream(Derivate.values()).filter(Derivate.by(messageType)).findFirst().orElseThrow(() -> new IllegalArgumentException("[" + messageType + "] ist an unsupported type"));
        }

        private static Predicate<Derivate> by(Class<?> type) {
            return value -> value.messageType.equals(type);
        }

        private Derivate(Class<?> messageType, BiConsumer<JavaMailSender, Object[]> dispatcher) {
            this.messageType = messageType;
            this.dispatcher = dispatcher;
        }
    }
}

