/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.spring.mail.javamail.concurrent;

import de.vinado.spring.mail.javamail.concurrent.Batch;
import de.vinado.spring.mail.javamail.concurrent.MailQueueException;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;

class BatchConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BatchConsumer.class);
    private final BlockingQueue<Batch> queue;
    private final JavaMailSender sender;

    @Override
    public void run() {
        try {
            while (true) {
                Batch batch = this.queue.take();
                if (log.isDebugEnabled()) {
                    log.debug("Dequeued {}", (Object)batch);
                    log.debug(this.queue.isEmpty() ? "Queue is empty now" : this.queue.size() + " batch(es) remain in the queue");
                }
                batch.dispatch(this.sender);
            }
        }
        catch (InterruptedException e) {
            if (!this.queue.isEmpty()) {
                if (log.isErrorEnabled()) {
                    log.error("Mail sender thread was interrupted but queue was not empty. Some Emails were not sent.");
                }
                throw new MailQueueException("Could not dequeue email batch", e);
            }
            return;
        }
    }

    public BatchConsumer(BlockingQueue<Batch> queue, JavaMailSender sender) {
        this.queue = queue;
        this.sender = sender;
    }
}

