/*
 * Decompiled with CFR 0.152.
 */
package de.vinado.spring.mail.javamail.dkim;

import de.vinado.spring.mail.javamail.JavaMailSenderDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class DkimJavaMailSender
extends JavaMailSenderDecorator
implements JavaMailSender {
    private final DkimSigner signer;

    DkimJavaMailSender(JavaMailSender delegate, DkimSigner signer) {
        super(delegate);
        this.signer = signer;
    }

    @Override
    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    @Override
    public void send(MimeMessage ... mimeMessages) throws MailException {
        MimeMessage[] signedMessages = (MimeMessage[])Arrays.stream(mimeMessages).map(this::createSignedMimeMessage).toArray(MimeMessage[]::new);
        super.send(signedMessages);
    }

    @Override
    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    @Override
    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(mimeMessagePreparators.length);
            for (MimeMessagePreparator preparator : mimeMessagePreparators) {
                MimeMessage mimeMessage = this.createMimeMessage();
                preparator.prepare(mimeMessage);
                mimeMessages.add(this.createSignedMimeMessage(mimeMessage));
            }
            super.send(mimeMessages.toArray(new MimeMessage[0]));
        }
        catch (MailException ex) {
            throw ex;
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new MailPreparationException((Throwable)ex);
        }
    }

    @Override
    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    @Override
    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(simpleMessages.length);
        for (SimpleMailMessage simpleMessage : simpleMessages) {
            MimeMailMessage message = new MimeMailMessage(this.createMimeMessage());
            simpleMessage.copyTo((MailMessage)message);
            mimeMessages.add(this.createSignedMimeMessage(message.getMimeMessage()));
        }
        super.send(mimeMessages.toArray(new MimeMessage[0]));
    }

    public MimeMessage createSignedMimeMessage(MimeMessage message) throws MailException {
        try {
            return new DkimMessage(message, this.signer);
        }
        catch (MessagingException e) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)e);
        }
    }
}

