package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * bbuffer.h<br>
 * Expandable byte buffer for reading data in from memory and<br>
 * writing data out to other memory.<br>
 * This implements a queue of bytes, so data read in is put<br>
 * on the "back" of the queue (i.e., the end of the byte array)<br>
 * and data written out is taken from the "front" of the queue<br>
 * (i.e., from an index marker "nwritten" that is initially set at<br>
 * the beginning of the array.) As usual with expandable<br>
 * arrays, we keep the size of the allocated array and the<br>
 * number of bytes that have been read into the array.<br>
 * For implementation details, see bbuffer.c.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\bbuffer.h:47</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class ByteBuffer extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * size of allocated byte array<br>
     * C type : l_int32
     */
    @Field(0)
    public int nalloc() {
        return this.io.getIntField(this, 0);
    }

    /**
     * size of allocated byte array<br>
     * C type : l_int32
     */
    @Field(0)
    public ByteBuffer nalloc(int nalloc) {
        this.io.setIntField(this, 0, nalloc);
        return this;
    }

    /**
     * number of bytes read into to the array<br>
     * C type : l_int32
     */
    @Field(1)
    public int n() {
        return this.io.getIntField(this, 1);
    }

    /**
     * number of bytes read into to the array<br>
     * C type : l_int32
     */
    @Field(1)
    public ByteBuffer n(int n) {
        this.io.setIntField(this, 1, n);
        return this;
    }

    /**
     * number of bytes written from the array<br>
     * C type : l_int32
     */
    @Field(2)
    public int nwritten() {
        return this.io.getIntField(this, 2);
    }

    /**
     * number of bytes written from the array<br>
     * C type : l_int32
     */
    @Field(2)
    public ByteBuffer nwritten(int nwritten) {
        this.io.setIntField(this, 2, nwritten);
        return this;
    }

    /**
     * byte array<br>
     * C type : l_uint8*
     */
    @Field(3)
    public Pointer<Byte> array() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * byte array<br>
     * C type : l_uint8*
     */
    @Field(3)
    public ByteBuffer array(Pointer<Byte> array) {
        this.io.setPointerField(this, 3, array);
        return this;
    }

    public ByteBuffer() {
        super();
    }

    public ByteBuffer(Pointer pointer) {
        super(pointer);
    }
}
