package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;

/**
 * In use, either datacomp or data85 will be produced, depending<br>
 * on whether the data needs to be ascii85 encoded. PostScript<br>
 * requires ascii85 encoding; pdf does not.<br>
 * For the colormap (flate compression only), PostScript uses ascii85<br>
 * encoding and pdf uses a bracketed array of space-separated<br>
 * hex-encoded rgb triples. Only tiff g4 (type == L_G4_ENCODE) uses<br>
 * the minisblack field.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\imageio.h:102</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Compressed_Data extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * encoding type: L_JPEG_ENCODE, etc<br>
     * C type : l_int32
     */
    @Field(0)
    public int type() {
        return this.io.getIntField(this, 0);
    }

    /**
     * encoding type: L_JPEG_ENCODE, etc<br>
     * C type : l_int32
     */
    @Field(0)
    public L_Compressed_Data type(int type) {
        this.io.setIntField(this, 0, type);
        return this;
    }

    /**
     * gzipped raster data<br>
     * C type : l_uint8*
     */
    @Field(1)
    public Pointer<Byte> datacomp() {
        return this.io.getPointerField(this, 1);
    }

    /**
     * gzipped raster data<br>
     * C type : l_uint8*
     */
    @Field(1)
    public L_Compressed_Data datacomp(Pointer<Byte> datacomp) {
        this.io.setPointerField(this, 1, datacomp);
        return this;
    }

    /** number of compressed bytes */
    @Ptr
    @Field(2)
    public long nbytescomp() {
        return this.io.getSizeTField(this, 2);
    }

    /** number of compressed bytes */
    @Ptr
    @Field(2)
    public L_Compressed_Data nbytescomp(long nbytescomp) {
        this.io.setSizeTField(this, 2, nbytescomp);
        return this;
    }

    /**
     * ascii85-encoded gzipped raster data<br>
     * C type : char*
     */
    @Field(3)
    public Pointer<Byte> data85() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * ascii85-encoded gzipped raster data<br>
     * C type : char*
     */
    @Field(3)
    public L_Compressed_Data data85(Pointer<Byte> data85) {
        this.io.setPointerField(this, 3, data85);
        return this;
    }

    /** number of ascii85 encoded bytes */
    @Ptr
    @Field(4)
    public long nbytes85() {
        return this.io.getSizeTField(this, 4);
    }

    /** number of ascii85 encoded bytes */
    @Ptr
    @Field(4)
    public L_Compressed_Data nbytes85(long nbytes85) {
        this.io.setSizeTField(this, 4, nbytes85);
        return this;
    }

    /**
     * ascii85-encoded uncompressed cmap<br>
     * C type : char*
     */
    @Field(5)
    public Pointer<Byte> cmapdata85() {
        return this.io.getPointerField(this, 5);
    }

    /**
     * ascii85-encoded uncompressed cmap<br>
     * C type : char*
     */
    @Field(5)
    public L_Compressed_Data cmapdata85(Pointer<Byte> cmapdata85) {
        this.io.setPointerField(this, 5, cmapdata85);
        return this;
    }

    /**
     * hex pdf array for the cmap<br>
     * C type : char*
     */
    @Field(6)
    public Pointer<Byte> cmapdatahex() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * hex pdf array for the cmap<br>
     * C type : char*
     */
    @Field(6)
    public L_Compressed_Data cmapdatahex(Pointer<Byte> cmapdatahex) {
        this.io.setPointerField(this, 6, cmapdatahex);
        return this;
    }

    /**
     * number of colors in cmap<br>
     * C type : l_int32
     */
    @Field(7)
    public int ncolors() {
        return this.io.getIntField(this, 7);
    }

    /**
     * number of colors in cmap<br>
     * C type : l_int32
     */
    @Field(7)
    public L_Compressed_Data ncolors(int ncolors) {
        this.io.setIntField(this, 7, ncolors);
        return this;
    }

    /**
     * image width<br>
     * C type : l_int32
     */
    @Field(8)
    public int w() {
        return this.io.getIntField(this, 8);
    }

    /**
     * image width<br>
     * C type : l_int32
     */
    @Field(8)
    public L_Compressed_Data w(int w) {
        this.io.setIntField(this, 8, w);
        return this;
    }

    /**
     * image height<br>
     * C type : l_int32
     */
    @Field(9)
    public int h() {
        return this.io.getIntField(this, 9);
    }

    /**
     * image height<br>
     * C type : l_int32
     */
    @Field(9)
    public L_Compressed_Data h(int h) {
        this.io.setIntField(this, 9, h);
        return this;
    }

    /**
     * bits/sample; typ. 1, 2, 4 or 8<br>
     * C type : l_int32
     */
    @Field(10)
    public int bps() {
        return this.io.getIntField(this, 10);
    }

    /**
     * bits/sample; typ. 1, 2, 4 or 8<br>
     * C type : l_int32
     */
    @Field(10)
    public L_Compressed_Data bps(int bps) {
        this.io.setIntField(this, 10, bps);
        return this;
    }

    /**
     * samples/pixel; typ. 1 or 3<br>
     * C type : l_int32
     */
    @Field(11)
    public int spp() {
        return this.io.getIntField(this, 11);
    }

    /**
     * samples/pixel; typ. 1 or 3<br>
     * C type : l_int32
     */
    @Field(11)
    public L_Compressed_Data spp(int spp) {
        this.io.setIntField(this, 11, spp);
        return this;
    }

    /**
     * tiff g4 photometry<br>
     * C type : l_int32
     */
    @Field(12)
    public int minisblack() {
        return this.io.getIntField(this, 12);
    }

    /**
     * tiff g4 photometry<br>
     * C type : l_int32
     */
    @Field(12)
    public L_Compressed_Data minisblack(int minisblack) {
        this.io.setIntField(this, 12, minisblack);
        return this;
    }

    /** number of uncompressed raster bytes */
    @Ptr
    @Field(13)
    public long nbytes() {
        return this.io.getSizeTField(this, 13);
    }

    /** number of uncompressed raster bytes */
    @Ptr
    @Field(13)
    public L_Compressed_Data nbytes(long nbytes) {
        this.io.setSizeTField(this, 13, nbytes);
        return this;
    }

    /**
     * resolution (ppi)<br>
     * C type : l_int32
     */
    @Field(14)
    public int res() {
        return this.io.getIntField(this, 14);
    }

    /**
     * resolution (ppi)<br>
     * C type : l_int32
     */
    @Field(14)
    public L_Compressed_Data res(int res) {
        this.io.setIntField(this, 14, res);
        return this;
    }

    public L_Compressed_Data() {
        super();
    }

    public L_Compressed_Data(Pointer pointer) {
        super(pointer);
    }
}
