package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * This accumulates data for generating a pdf of a single page consisting<br>
 * of an arbitrary number of images.<br>
 * None of the strings have a trailing newline.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\imageio.h:138</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Pdf_Data extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * optional title for pdf<br>
     * C type : char*
     */
    @Field(0)
    public Pointer<Byte> title() {
        return this.io.getPointerField(this, 0);
    }

    /**
     * optional title for pdf<br>
     * C type : char*
     */
    @Field(0)
    public L_Pdf_Data title(Pointer<Byte> title) {
        this.io.setPointerField(this, 0, title);
        return this;
    }

    /**
     * number of images<br>
     * C type : l_int32
     */
    @Field(1)
    public int n() {
        return this.io.getIntField(this, 1);
    }

    /**
     * number of images<br>
     * C type : l_int32
     */
    @Field(1)
    public L_Pdf_Data n(int n) {
        this.io.setIntField(this, 1, n);
        return this;
    }

    /**
     * number of colormaps<br>
     * C type : l_int32
     */
    @Field(2)
    public int ncmap() {
        return this.io.getIntField(this, 2);
    }

    /**
     * number of colormaps<br>
     * C type : l_int32
     */
    @Field(2)
    public L_Pdf_Data ncmap(int ncmap) {
        this.io.setIntField(this, 2, ncmap);
        return this;
    }

    /**
     * array of compressed image data<br>
     * C type : L_Ptra*
     */
    @Field(3)
    public Pointer<L_Ptra> cida() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * array of compressed image data<br>
     * C type : L_Ptra*
     */
    @Field(3)
    public L_Pdf_Data cida(Pointer<L_Ptra> cida) {
        this.io.setPointerField(this, 3, cida);
        return this;
    }

    /**
     * %PDF-1.2 id string<br>
     * C type : char*
     */
    @Field(4)
    public Pointer<Byte> id() {
        return this.io.getPointerField(this, 4);
    }

    /**
     * %PDF-1.2 id string<br>
     * C type : char*
     */
    @Field(4)
    public L_Pdf_Data id(Pointer<Byte> id) {
        this.io.setPointerField(this, 4, id);
        return this;
    }

    /**
     * catalog string<br>
     * C type : char*
     */
    @Field(5)
    public Pointer<Byte> obj1() {
        return this.io.getPointerField(this, 5);
    }

    /**
     * catalog string<br>
     * C type : char*
     */
    @Field(5)
    public L_Pdf_Data obj1(Pointer<Byte> obj1) {
        this.io.setPointerField(this, 5, obj1);
        return this;
    }

    /**
     * metadata string<br>
     * C type : char*
     */
    @Field(6)
    public Pointer<Byte> obj2() {
        return this.io.getPointerField(this, 6);
    }

    /**
     * metadata string<br>
     * C type : char*
     */
    @Field(6)
    public L_Pdf_Data obj2(Pointer<Byte> obj2) {
        this.io.setPointerField(this, 6, obj2);
        return this;
    }

    /**
     * pages string<br>
     * C type : char*
     */
    @Field(7)
    public Pointer<Byte> obj3() {
        return this.io.getPointerField(this, 7);
    }

    /**
     * pages string<br>
     * C type : char*
     */
    @Field(7)
    public L_Pdf_Data obj3(Pointer<Byte> obj3) {
        this.io.setPointerField(this, 7, obj3);
        return this;
    }

    /**
     * page string (variable data)<br>
     * C type : char*
     */
    @Field(8)
    public Pointer<Byte> obj4() {
        return this.io.getPointerField(this, 8);
    }

    /**
     * page string (variable data)<br>
     * C type : char*
     */
    @Field(8)
    public L_Pdf_Data obj4(Pointer<Byte> obj4) {
        this.io.setPointerField(this, 8, obj4);
        return this;
    }

    /**
     * content string (variable data)<br>
     * C type : char*
     */
    @Field(9)
    public Pointer<Byte> obj5() {
        return this.io.getPointerField(this, 9);
    }

    /**
     * content string (variable data)<br>
     * C type : char*
     */
    @Field(9)
    public L_Pdf_Data obj5(Pointer<Byte> obj5) {
        this.io.setPointerField(this, 9, obj5);
        return this;
    }

    /**
     * post-binary-stream string<br>
     * C type : char*
     */
    @Field(10)
    public Pointer<Byte> poststream() {
        return this.io.getPointerField(this, 10);
    }

    /**
     * post-binary-stream string<br>
     * C type : char*
     */
    @Field(10)
    public L_Pdf_Data poststream(Pointer<Byte> poststream) {
        this.io.setPointerField(this, 10, poststream);
        return this;
    }

    /**
     * trailer string (variable data)<br>
     * C type : char*
     */
    @Field(11)
    public Pointer<Byte> trailer() {
        return this.io.getPointerField(this, 11);
    }

    /**
     * trailer string (variable data)<br>
     * C type : char*
     */
    @Field(11)
    public L_Pdf_Data trailer(Pointer<Byte> trailer) {
        this.io.setPointerField(this, 11, trailer);
        return this;
    }

    /**
     * store (xpt, ypt) array<br>
     * C type : Pta*
     */
    @Field(12)
    public Pointer<Pta> xy() {
        return this.io.getPointerField(this, 12);
    }

    /**
     * store (xpt, ypt) array<br>
     * C type : Pta*
     */
    @Field(12)
    public L_Pdf_Data xy(Pointer<Pta> xy) {
        this.io.setPointerField(this, 12, xy);
        return this;
    }

    /**
     * store (wpt, hpt) array<br>
     * C type : Pta*
     */
    @Field(13)
    public Pointer<Pta> wh() {
        return this.io.getPointerField(this, 13);
    }

    /**
     * store (wpt, hpt) array<br>
     * C type : Pta*
     */
    @Field(13)
    public L_Pdf_Data wh(Pointer<Pta> wh) {
        this.io.setPointerField(this, 13, wh);
        return this;
    }

    /**
     * bounding region for all images<br>
     * C type : Box*
     */
    @Field(14)
    public Pointer<Box> mediabox() {
        return this.io.getPointerField(this, 14);
    }

    /**
     * bounding region for all images<br>
     * C type : Box*
     */
    @Field(14)
    public L_Pdf_Data mediabox(Pointer<Box> mediabox) {
        this.io.setPointerField(this, 14, mediabox);
        return this;
    }

    /**
     * pre-binary-stream xobject strings<br>
     * C type : Sarray*
     */
    @Field(15)
    public Pointer<Sarray> saprex() {
        return this.io.getPointerField(this, 15);
    }

    /**
     * pre-binary-stream xobject strings<br>
     * C type : Sarray*
     */
    @Field(15)
    public L_Pdf_Data saprex(Pointer<Sarray> saprex) {
        this.io.setPointerField(this, 15, saprex);
        return this;
    }

    /**
     * colormap pdf object strings<br>
     * C type : Sarray*
     */
    @Field(16)
    public Pointer<Sarray> sacmap() {
        return this.io.getPointerField(this, 16);
    }

    /**
     * colormap pdf object strings<br>
     * C type : Sarray*
     */
    @Field(16)
    public L_Pdf_Data sacmap(Pointer<Sarray> sacmap) {
        this.io.setPointerField(this, 16, sacmap);
        return this;
    }

    /**
     * sizes of each pdf string object<br>
     * C type : L_Dna*
     */
    @Field(17)
    public Pointer<L_Dna> objsize() {
        return this.io.getPointerField(this, 17);
    }

    /**
     * sizes of each pdf string object<br>
     * C type : L_Dna*
     */
    @Field(17)
    public L_Pdf_Data objsize(Pointer<L_Dna> objsize) {
        this.io.setPointerField(this, 17, objsize);
        return this;
    }

    /**
     * location of each pdf string object<br>
     * C type : L_Dna*
     */
    @Field(18)
    public Pointer<L_Dna> objloc() {
        return this.io.getPointerField(this, 18);
    }

    /**
     * location of each pdf string object<br>
     * C type : L_Dna*
     */
    @Field(18)
    public L_Pdf_Data objloc(Pointer<L_Dna> objloc) {
        this.io.setPointerField(this, 18, objloc);
        return this;
    }

    /**
     * location of xref<br>
     * C type : l_int32
     */
    @Field(19)
    public int xrefloc() {
        return this.io.getIntField(this, 19);
    }

    /**
     * location of xref<br>
     * C type : l_int32
     */
    @Field(19)
    public L_Pdf_Data xrefloc(int xrefloc) {
        this.io.setIntField(this, 19, xrefloc);
        return this;
    }

    public L_Pdf_Data() {
        super();
    }

    public L_Pdf_Data(Pointer pointer) {
        super(pointer);
    }
}
