package de.vorb.leptonica;

import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;

/**
 * sudoku.h<br>
 * The L_Sudoku holds all the information of the current state.<br>
 * The input to sudokuCreate() is a file with any number of lines<br>
 * starting with '#', followed by 9 lines consisting of 9 numbers<br>
 * in each line. These have the known values and use 0 for the unknowns.<br>
 * Blank lines are ignored.<br>
 * The @locs array holds the indices of the unknowns, numbered<br>
 * left-to-right and top-to-bottom from 0 to 80. The array size<br>
 * is initialized to @num. @current is the index into the @locs<br>
 * array of the current guess: locs[current].<br>
 * The @state array is used to determine the validity of each guess.<br>
 * It is of size 81, and is initialized by setting the unknowns to 0<br>
 * and the knowns to their input values.<br>
 * <i>native declaration :
 * C:\Users\Paul\Studium\Masterarbeit\Entwicklung\VS2013\
 * tesseract-vs2013\liblept\include\sudoku.h:49</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("leptonica")
public class L_Sudoku extends StructObject {
    static {
        BridJ.register();
    }

    /**
     * number of unknowns<br>
     * C type : l_int32
     */
    @Field(0)
    public int num() {
        return this.io.getIntField(this, 0);
    }

    /**
     * number of unknowns<br>
     * C type : l_int32
     */
    @Field(0)
    public L_Sudoku num(int num) {
        this.io.setIntField(this, 0, num);
        return this;
    }

    /**
     * location of unknowns<br>
     * C type : l_int32*
     */
    @Field(1)
    public Pointer<Integer> locs() {
        return this.io.getPointerField(this, 1);
    }

    /**
     * location of unknowns<br>
     * C type : l_int32*
     */
    @Field(1)
    public L_Sudoku locs(Pointer<Integer> locs) {
        this.io.setPointerField(this, 1, locs);
        return this;
    }

    /**
     * index into @locs of current location<br>
     * C type : l_int32
     */
    @Field(2)
    public int current() {
        return this.io.getIntField(this, 2);
    }

    /**
     * index into @locs of current location<br>
     * C type : l_int32
     */
    @Field(2)
    public L_Sudoku current(int current) {
        this.io.setIntField(this, 2, current);
        return this;
    }

    /**
     * initial state, with 0 representing<br>
     * C type : l_int32*
     */
    @Field(3)
    public Pointer<Integer> init() {
        return this.io.getPointerField(this, 3);
    }

    /**
     * initial state, with 0 representing<br>
     * C type : l_int32*
     */
    @Field(3)
    public L_Sudoku init(Pointer<Integer> init) {
        this.io.setPointerField(this, 3, init);
        return this;
    }

    /**
     * present state, including inits and<br>
     * C type : l_int32*
     */
    @Field(4)
    public Pointer<Integer> state() {
        return this.io.getPointerField(this, 4);
    }

    /**
     * present state, including inits and<br>
     * C type : l_int32*
     */
    @Field(4)
    public L_Sudoku state(Pointer<Integer> state) {
        this.io.setPointerField(this, 4, state);
        return this;
    }

    /**
     * shows current number of guesses<br>
     * C type : l_int32
     */
    @Field(5)
    public int nguess() {
        return this.io.getIntField(this, 5);
    }

    /**
     * shows current number of guesses<br>
     * C type : l_int32
     */
    @Field(5)
    public L_Sudoku nguess(int nguess) {
        this.io.setIntField(this, 5, nguess);
        return this;
    }

    /**
     * set to 1 when solved<br>
     * C type : l_int32
     */
    @Field(6)
    public int finished() {
        return this.io.getIntField(this, 6);
    }

    /**
     * set to 1 when solved<br>
     * C type : l_int32
     */
    @Field(6)
    public L_Sudoku finished(int finished) {
        this.io.setIntField(this, 6, finished);
        return this;
    }

    /**
     * set to 1 if no solution is possible<br>
     * C type : l_int32
     */
    @Field(7)
    public int failure() {
        return this.io.getIntField(this, 7);
    }

    /**
     * set to 1 if no solution is possible<br>
     * C type : l_int32
     */
    @Field(7)
    public L_Sudoku failure(int failure) {
        this.io.setIntField(this, 7, failure);
        return this;
    }

    public L_Sudoku() {
        super();
    }

    public L_Sudoku(Pointer pointer) {
        super(pointer);
    }
}
