/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class AbstractDirectory {
    public static final int MAX_LABEL_LENGTH = 11;
    private final List<AbstractDirectoryEntry> entries = new ArrayList<AbstractDirectoryEntry>();
    private final boolean readOnly;
    private final boolean isRoot;
    private boolean dirty;
    private int capacity;
    private String volumeLabel;

    protected AbstractDirectory(int capacity, boolean readOnly, boolean isRoot) {
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.isRoot = isRoot;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    protected abstract void write(ByteBuffer var1) throws IOException;

    protected abstract long getStorageCluster();

    protected abstract void changeSize(int var1) throws DirectoryFullException, IOException;

    protected final void checkEntryCount(int entryCount) throws IllegalArgumentException {
        if (entryCount < 0) {
            throw new IllegalArgumentException("invalid entry count of " + entryCount);
        }
    }

    public void setEntries(List<AbstractDirectoryEntry> newEntries) {
        if (newEntries.size() > this.capacity) {
            throw new IllegalArgumentException("too many entries");
        }
        this.entries.clear();
        this.entries.addAll(newEntries);
    }

    protected final void sizeChanged(long newSize) throws IOException {
        long newCount = newSize / 32L;
        if (newCount > Integer.MAX_VALUE) {
            throw new IOException("directory too large");
        }
        this.capacity = (int)newCount;
    }

    public final AbstractDirectoryEntry getEntry(int idx) {
        return this.entries.get(idx);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public int getSize() {
        return this.entries.size() + (this.volumeLabel != null ? 1 : 0);
    }

    protected final void setDirty() {
        this.dirty = true;
    }

    private void checkRoot() throws UnsupportedOperationException {
        if (!this.isRoot()) {
            throw new UnsupportedOperationException("only supported on root directories");
        }
    }

    private void resetDirty() {
        this.dirty = false;
    }

    public void flush() throws IOException {
        int volLabelOffset;
        ByteBuffer data = ByteBuffer.allocate(this.getCapacity() * 32);
        if (this.volumeLabel != null) {
            volLabelOffset = 32;
            AbstractDirectoryEntry labelEntry = new AbstractDirectoryEntry(this);
            labelEntry.setFlags(8);
            System.arraycopy(this.volumeLabel.getBytes(), 0, labelEntry.getData(), 0, this.volumeLabel.length());
            labelEntry.write(data.array(), 0);
        } else {
            volLabelOffset = 0;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            AbstractDirectoryEntry entry = this.entries.get(i);
            if (entry == null) continue;
            entry.write(data.array(), i * 32 + volLabelOffset);
        }
        this.write(data);
        this.resetDirty();
    }

    protected final void read() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(this.getCapacity() * 32);
        this.read(data);
        byte[] src = data.array();
        for (int i = 0; i < this.getCapacity(); ++i) {
            int offset = i * 32;
            if (src[offset] == 0) continue;
            AbstractDirectoryEntry entry = new AbstractDirectoryEntry(this, src, offset);
            if (entry.isVolumeLabel()) {
                this.parseVolumeLabel(entry);
                continue;
            }
            this.entries.add(entry);
        }
    }

    public void addEntry(AbstractDirectoryEntry e) throws IOException {
        assert (e != null);
        if (this.getSize() == this.getCapacity()) {
            this.changeSize(this.getCapacity() + 1);
        }
        this.entries.add(e);
    }

    public void addEntries(AbstractDirectoryEntry[] entries) throws IOException {
        if (this.getSize() + entries.length > this.getCapacity()) {
            this.changeSize(this.getSize() + entries.length);
        }
        this.entries.addAll(Arrays.asList(entries));
    }

    public void removeEntry(AbstractDirectoryEntry entry) throws IOException {
        assert (entry != null);
        this.entries.remove(entry);
        this.changeSize(this.getSize());
    }

    public String getLabel() throws UnsupportedOperationException {
        this.checkRoot();
        return this.volumeLabel;
    }

    public void setLabel(String label) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        this.checkRoot();
        if (label.length() > 11) {
            throw new IllegalArgumentException("label too long");
        }
        if (this.volumeLabel != null) {
            if (label == null) {
                this.changeSize(this.getSize() - 1);
                this.volumeLabel = null;
            } else {
                ShortName.checkValidChars(label.toCharArray());
                this.volumeLabel = label;
            }
        } else if (label != null) {
            this.changeSize(this.getSize() + 1);
            ShortName.checkValidChars(label.toCharArray());
            this.volumeLabel = label;
        }
        this.dirty = true;
    }

    private void parseVolumeLabel(AbstractDirectoryEntry entry) {
        byte b;
        if (!entry.isVolumeLabel()) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11 && (b = entry.getData()[i]) != 0; ++i) {
            sb.append((char)b);
        }
        this.volumeLabel = sb.toString();
    }
}

