/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.DosUtils;
import de.waldheinz.fs.fat.LittleEndian;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;

final class FatDirEntry {
    public static final int OFFSET_LENGTH = 28;
    private final AbstractDirectoryEntry entry;

    private FatDirEntry(AbstractDirectoryEntry entry) {
        this.entry = entry;
    }

    public static FatDirEntry read(AbstractDirectoryEntry e) {
        return new FatDirEntry(e);
    }

    public static FatDirEntry create(AbstractDirectoryEntry e) {
        FatDirEntry result = new FatDirEntry(e);
        long now = System.currentTimeMillis();
        result.setCreated(now);
        result.setLastAccessed(now);
        result.setLastModified(now);
        return result;
    }

    public AbstractDirectoryEntry getEntry() {
        return this.entry;
    }

    public long getCreated() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.entry.getData(), 16), LittleEndian.getUInt16(this.entry.getData(), 14));
    }

    public void setCreated(long created) {
        LittleEndian.setInt16(this.entry.getData(), 14, DosUtils.encodeTime(created));
        LittleEndian.setInt16(this.entry.getData(), 16, DosUtils.encodeDate(created));
        this.entry.markDirty();
    }

    public long getLastModified() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.entry.getData(), 24), LittleEndian.getUInt16(this.entry.getData(), 22));
    }

    public void setLastModified(long lastModified) {
        LittleEndian.setInt16(this.entry.getData(), 22, DosUtils.encodeTime(lastModified));
        LittleEndian.setInt16(this.entry.getData(), 24, DosUtils.encodeDate(lastModified));
        this.entry.markDirty();
    }

    public long getLastAccessed() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.entry.getData(), 18), 0);
    }

    public void setLastAccessed(long lastAccessed) {
        LittleEndian.setInt16(this.entry.getData(), 18, DosUtils.encodeDate(lastAccessed));
        this.entry.markDirty();
    }

    public boolean isDeleted() {
        return LittleEndian.getUInt8(this.entry.getData(), 0) == 229;
    }

    public long getLength() {
        return LittleEndian.getUInt32(this.entry.getData(), 28);
    }

    public void setLength(long length) throws IllegalArgumentException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("too big");
        }
        LittleEndian.setInt32(this.entry.getData(), 28, (int)length);
        this.entry.markDirty();
    }

    public ShortName getName() {
        return ShortName.parse(this.entry);
    }

    public void setName(ShortName sn) {
        sn.write(this.entry);
    }

    public long getStartCluster() {
        return LittleEndian.getUInt16(this.entry.getData(), 26);
    }

    void setStartCluster(long startCluster) {
        if (startCluster > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        LittleEndian.setInt16(this.entry.getData(), 26, (int)startCluster);
        this.entry.markDirty();
    }

    void remove() throws IOException {
        this.entry.remove();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getName() + "]";
    }
}

