/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirEntry;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;

final class FatDirectory
extends ClusterChainDirectory {
    private final FatDirEntry entry;

    private FatDirectory(ClusterChain chain, FatDirEntry entry) {
        super(chain, false);
        this.entry = entry;
    }

    public static FatDirectory read(FatDirEntry entry, Fat fat) throws IOException {
        if (!entry.getEntry().isDirectory()) {
            throw new IllegalArgumentException(entry + " is no directory");
        }
        ClusterChain chain = new ClusterChain(fat, entry.getStartCluster(), entry.getEntry().isReadOnly());
        FatDirectory result = new FatDirectory(chain, entry);
        result.read();
        return result;
    }

    public static FatDirectory createSub(AbstractDirectory parent, Fat fat) throws IOException {
        ClusterChain chain = new ClusterChain(fat, false);
        chain.setChainLength(1);
        AbstractDirectoryEntry entryData = new AbstractDirectoryEntry(parent);
        FatDirEntry realEntry = FatDirEntry.create(entryData);
        realEntry.getEntry().setFlags(16);
        realEntry.setStartCluster(chain.getStartCluster());
        FatDirectory result = new FatDirectory(chain, realEntry);
        AbstractDirectoryEntry dot = new AbstractDirectoryEntry(result);
        dot.setFlags(16);
        FatDirEntry dotEntry = FatDirEntry.create(dot);
        dotEntry.setName(ShortName.DOT);
        dotEntry.setStartCluster((int)result.getStorageCluster());
        FatDirectory.copyDateTimeFields(realEntry, dotEntry);
        result.addEntry(dot);
        AbstractDirectoryEntry dotDot = new AbstractDirectoryEntry(result);
        dotDot.setFlags(16);
        FatDirEntry dotDotEntry = FatDirEntry.create(dotDot);
        dotDotEntry.setName(ShortName.DOT_DOT);
        dotDotEntry.setStartCluster((int)parent.getStorageCluster());
        FatDirectory.copyDateTimeFields(realEntry, dotDotEntry);
        result.addEntry(dotDot);
        result.flush();
        return result;
    }

    public FatDirEntry getEntry() {
        return this.entry;
    }

    private static void copyDateTimeFields(FatDirEntry src, FatDirEntry dst) {
        dst.setCreated(src.getCreated());
        dst.setLastAccessed(src.getLastAccessed());
        dst.setLastModified(src.getLastModified());
    }
}

