/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirEntry;
import de.waldheinz.fs.fat.FatObject;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

final class FatFile
extends FatObject
implements FsFile {
    private final FatDirEntry entry;
    private final ClusterChain chain;

    private FatFile(FatDirEntry myEntry, ClusterChain chain) {
        this.entry = myEntry;
        this.chain = chain;
    }

    public static FatFile get(Fat fat, FatDirEntry entry) throws IOException {
        if (entry.getEntry().isDirectory()) {
            throw new IllegalArgumentException(entry + " is a directory");
        }
        ClusterChain cc = new ClusterChain(fat, entry.getStartCluster(), entry.getEntry().isReadOnly());
        if (entry.getLength() > cc.getLengthOnDisk()) {
            throw new IOException("entry is largen than associated cluster chain");
        }
        return new FatFile(entry, cc);
    }

    @Override
    public long getLength() {
        return this.entry.getLength();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [length=" + this.getLength() + ", first cluster=" + this.chain.getStartCluster() + "]";
    }

    @Override
    public void setLength(long length) throws ReadOnlyException, IOException {
        if (this.getLength() == length) {
            return;
        }
        if (this.chain.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.updateTimeStamps(true);
        this.chain.setSize(length);
        this.entry.setStartCluster(this.chain.getStartCluster());
        this.entry.setLength(length);
    }

    @Override
    public void read(long offset, ByteBuffer dest) throws IOException {
        int len = dest.remaining();
        if (len == 0) {
            return;
        }
        if (offset + (long)len > this.getLength()) {
            throw new EOFException();
        }
        if (!this.chain.isReadOnly()) {
            this.updateTimeStamps(false);
        }
        this.chain.readData(offset, dest);
    }

    @Override
    public void write(long offset, ByteBuffer srcBuf) throws ReadOnlyException, IOException {
        if (this.chain.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.updateTimeStamps(true);
        long lastByte = offset + (long)srcBuf.remaining();
        if (lastByte > this.getLength()) {
            this.setLength(lastByte);
        }
        this.chain.writeData(offset, srcBuf);
    }

    private void updateTimeStamps(boolean write) {
        long now = System.currentTimeMillis();
        this.entry.setLastAccessed(now);
        if (write) {
            this.entry.setLastModified(now);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public ClusterChain getChain() {
        return this.chain;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FatFile)) {
            return false;
        }
        FatFile other = (FatFile)obj;
        if (!(this.entry == other.entry || this.entry != null && this.entry.equals(other.entry))) {
            return false;
        }
        return this.chain == other.chain || this.chain != null && this.chain.equals(other.chain);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.entry != null ? this.entry.hashCode() : 0);
        hash = 97 * hash + (this.chain != null ? this.chain.hashCode() : 0);
        return hash;
    }
}

