/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.FatDirEntry;
import de.waldheinz.fs.fat.FatDirectory;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatLfnDirEntry;
import de.waldheinz.fs.fat.ShortName;
import de.waldheinz.fs.fat.ShortNameGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

final class FatLfnDirectory
implements FsDirectory {
    private final Map<ShortName, LfnEntry> shortNameIndex;
    private final Map<String, LfnEntry> longNameIndex;
    private final Map<FatDirEntry, FatFile> files;
    private final Map<FatDirEntry, FatLfnDirectory> directories;
    private final ShortNameGenerator sng;
    private final AbstractDirectory dir;
    private final Fat fat;

    public FatLfnDirectory(AbstractDirectory dir, Fat fat) {
        if (dir == null || fat == null) {
            throw new NullPointerException();
        }
        this.fat = fat;
        this.dir = dir;
        this.shortNameIndex = new LinkedHashMap<ShortName, LfnEntry>();
        this.longNameIndex = new LinkedHashMap<String, LfnEntry>();
        this.sng = new ShortNameGenerator(this.shortNameIndex.keySet());
        this.files = new LinkedHashMap<FatDirEntry, FatFile>();
        this.directories = new LinkedHashMap<FatDirEntry, FatLfnDirectory>();
        this.parseLfn();
    }

    private void checkReadOnly() throws ReadOnlyException {
        if (this.dir.isReadOnly()) {
            throw new ReadOnlyException();
        }
    }

    private FatFile getFile(FatDirEntry entry) throws IOException {
        FatFile file = this.files.get(entry);
        if (file == null) {
            file = FatFile.get(this.fat, entry);
            this.files.put(entry, file);
        }
        return file;
    }

    private FsDirectory getDirectory(FatDirEntry entry) throws IOException {
        FatLfnDirectory result = this.directories.get(entry);
        if (result == null) {
            FatDirectory storage = FatDirectory.read(entry, this.fat);
            result = new FatLfnDirectory(storage, this.fat);
            this.directories.put(entry, result);
        }
        return result;
    }

    public AbstractDirectory getStorageDirectory() {
        return this.dir;
    }

    @Override
    public LfnEntry addFile(String name) throws IOException {
        this.checkReadOnly();
        name = name.trim();
        ShortName shortName = this.makeShortName(name);
        AbstractDirectoryEntry entryData = new AbstractDirectoryEntry(this.dir);
        FatDirEntry realEntry = FatDirEntry.create(entryData);
        realEntry.setName(shortName);
        LfnEntry entry = new LfnEntry(realEntry, name);
        this.dir.addEntries(entry.compactForm());
        this.shortNameIndex.put(shortName, entry);
        this.longNameIndex.put(name, entry);
        this.getFile(realEntry);
        this.dir.setDirty();
        return entry;
    }

    private ShortName makeShortName(String name) throws IOException {
        try {
            return this.sng.generateShortName(name);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("could not generate short name for \"" + name + "\"", ex);
        }
    }

    @Override
    public LfnEntry addDirectory(String name) throws IOException {
        this.checkReadOnly();
        name = name.trim();
        ShortName sn = this.makeShortName(name);
        FatDirectory newDir = FatDirectory.createSub(this.dir, this.fat);
        FatDirEntry realEntry = newDir.getEntry();
        realEntry.setName(sn);
        LfnEntry entry = new LfnEntry(realEntry, name);
        try {
            this.dir.addEntries(entry.compactForm());
        }
        catch (IOException ex) {
            newDir.delete();
            throw ex;
        }
        this.shortNameIndex.put(sn, entry);
        this.longNameIndex.put(name, entry);
        this.getDirectory(realEntry);
        this.flush();
        return entry;
    }

    private LfnEntry getEntryImpl(String name) {
        LfnEntry entry = this.longNameIndex.get(name = name.trim());
        if (entry == null) {
            if (!ShortName.canConvert(name)) {
                return null;
            }
            return this.shortNameIndex.get(ShortName.get(name));
        }
        return entry;
    }

    private void parseLfn() {
        int i = 0;
        int size = this.dir.getEntryCount();
        while (i < size) {
            LfnEntry current;
            while (i < size && this.dir.getEntry(i) == null) {
                ++i;
            }
            if (i >= size) break;
            int offset = i;
            while (this.dir.getEntry(i).isLfnEntry() && ++i < size) {
            }
            if (i >= size) break;
            if ((current = new LfnEntry(offset, ++i - offset)).isDeleted() || !current.isValid()) continue;
            this.shortNameIndex.put(current.getRealEntry().getName(), current);
            this.longNameIndex.put(current.getName(), current);
        }
    }

    private void updateLFN() throws IOException {
        ArrayList<AbstractDirectoryEntry> destination = new ArrayList<AbstractDirectoryEntry>();
        for (LfnEntry currentEntry : this.shortNameIndex.values()) {
            AbstractDirectoryEntry[] encoded = currentEntry.compactForm();
            destination.addAll(Arrays.asList(encoded));
        }
        int size = destination.size();
        this.dir.changeSize(size);
        this.dir.setEntries(destination);
    }

    @Override
    public void flush() throws IOException {
        for (FatFile f : this.files.values()) {
            f.flush();
        }
        for (FatLfnDirectory d : this.directories.values()) {
            d.flush();
        }
        this.updateLFN();
        this.dir.flush();
    }

    @Override
    public Iterator<FsDirectoryEntry> iterator() {
        return new Iterator<FsDirectoryEntry>(){
            Iterator<LfnEntry> it;
            {
                this.it = FatLfnDirectory.this.shortNameIndex.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FsDirectoryEntry next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void remove(String name) throws IOException, IllegalArgumentException {
        this.checkReadOnly();
        LfnEntry entry = this.getEntryImpl(name);
        if (entry == null) {
            return;
        }
        entry.remove();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [size=" + this.shortNameIndex.size() + ", dir=" + this.dir + "]";
    }

    @Override
    public FsDirectoryEntry getEntry(String name) throws IOException {
        return this.getEntryImpl(name);
    }

    class LfnEntry
    implements FsDirectoryEntry {
        private String fileName;
        private final FatDirEntry realEntry;

        public LfnEntry(FatDirEntry realEntry, String name) {
            this.realEntry = realEntry;
            this.fileName = name;
        }

        public LfnEntry(int offset, int length) {
            if (length == 1) {
                this.realEntry = FatDirEntry.read(FatLfnDirectory.this.dir.getEntry(offset));
                this.fileName = this.realEntry.getName().asSimpleString();
            } else {
                StringBuilder name = new StringBuilder(13 * (length - 1));
                for (int i = length - 2; i >= 0; --i) {
                    AbstractDirectoryEntry entry = FatLfnDirectory.this.dir.getEntry(i + offset);
                    name.append(FatLfnDirEntry.getSubstring(entry));
                }
                this.fileName = name.toString().trim();
                this.realEntry = FatDirEntry.read(FatLfnDirectory.this.dir.getEntry(offset + length - 1));
            }
        }

        public int totalEntrySize() {
            int result = this.fileName.length() / 13 + 1;
            if (this.fileName.length() % 13 != 0) {
                ++result;
            }
            return result;
        }

        public AbstractDirectoryEntry[] compactForm() {
            if (this.realEntry.getName().equals(ShortName.DOT) || this.realEntry.getName().equals(ShortName.DOT_DOT)) {
                return new AbstractDirectoryEntry[]{this.realEntry.getEntry()};
            }
            int totalEntrySize = this.totalEntrySize();
            AbstractDirectoryEntry[] entries = new AbstractDirectoryEntry[totalEntrySize];
            int j = 0;
            byte checkSum = this.realEntry.getName().checkSum();
            for (int i = totalEntrySize - 2; i > 0; --i) {
                entries[i] = new AbstractDirectoryEntry(FatLfnDirectory.this.getStorageDirectory());
                FatLfnDirEntry.set(entries[i], this.fileName.substring(j * 13, j * 13 + 13), j + 1, checkSum, false);
                ++j;
            }
            entries[0] = new AbstractDirectoryEntry(FatLfnDirectory.this.getStorageDirectory());
            FatLfnDirEntry.set(entries[0], this.fileName.substring(j * 13), j + 1, checkSum, true);
            entries[totalEntrySize - 1] = this.realEntry.getEntry();
            return entries;
        }

        @Override
        public String getName() {
            return this.fileName;
        }

        @Override
        public FsDirectory getParent() {
            return FatLfnDirectory.this;
        }

        @Override
        public long getCreated() {
            return this.realEntry.getCreated();
        }

        @Override
        public long getLastModified() {
            return this.realEntry.getLastModified();
        }

        @Override
        public long getLastAccessed() {
            return this.realEntry.getLastAccessed();
        }

        @Override
        public boolean isFile() {
            return this.realEntry.getEntry().isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.realEntry.getEntry().isDirectory();
        }

        @Override
        public void setName(String newName) {
            FatLfnDirectory.this.checkReadOnly();
            this.fileName = newName;
            this.realEntry.setName(FatLfnDirectory.this.sng.generateShortName(newName));
        }

        public void setCreated(long created) {
            FatLfnDirectory.this.checkReadOnly();
            this.realEntry.setCreated(created);
        }

        @Override
        public void setLastModified(long lastModified) {
            FatLfnDirectory.this.checkReadOnly();
            this.realEntry.setLastModified(lastModified);
        }

        public void setLastAccessed(long lastAccessed) {
            FatLfnDirectory.this.checkReadOnly();
            this.realEntry.setLastAccessed(lastAccessed);
        }

        @Override
        public FatFile getFile() throws IOException {
            return FatLfnDirectory.this.getFile(this.realEntry);
        }

        @Override
        public FsDirectory getDirectory() throws IOException {
            return FatLfnDirectory.this.getDirectory(this.realEntry);
        }

        @Override
        public boolean isValid() {
            return this.realEntry.getEntry().isValid();
        }

        public boolean isDeleted() {
            return this.realEntry.isDeleted();
        }

        public String toString() {
            return "LFN = " + this.fileName + " / SFN = " + this.realEntry.getName();
        }

        public FatDirEntry getRealEntry() {
            return this.realEntry;
        }

        @Override
        public boolean isDirty() {
            return true;
        }

        private void remove() throws IOException {
            FatLfnDirectory.this.checkReadOnly();
            if (this.realEntry.getName().equals(ShortName.DOT) || this.realEntry.getName().equals(ShortName.DOT_DOT)) {
                throw new IllegalArgumentException("the dot entries can not be removed");
            }
            ClusterChain cc = new ClusterChain(FatLfnDirectory.this.fat, this.realEntry.getStartCluster(), false);
            cc.setChainLength(0);
            FatLfnDirectory.this.longNameIndex.remove(this.getName());
            FatLfnDirectory.this.shortNameIndex.remove(this.realEntry.getName());
            if (this.isFile()) {
                FatLfnDirectory.this.files.remove(this.realEntry);
            } else {
                FatLfnDirectory.this.files.remove(this.realEntry);
            }
            this.realEntry.remove();
            FatLfnDirectory.this.updateLFN();
        }
    }
}

