/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.LittleEndian;

class FatUtils {
    public static final int SUBNAME_SIZE = 13;

    public static long getFatOffset(BootSector bs, int fatNr) {
        long sectSize = bs.getBytesPerSector();
        long sectsPerFat = bs.getSectorsPerFat();
        long resSects = bs.getNrReservedSectors();
        long offset = resSects * sectSize;
        long fatSize = sectsPerFat * sectSize;
        return offset += (long)fatNr * fatSize;
    }

    public static long getRootDirOffset(BootSector bs) {
        long sectSize = bs.getBytesPerSector();
        long sectsPerFat = bs.getSectorsPerFat();
        int fats = bs.getNrFats();
        long offset = FatUtils.getFatOffset(bs, 0);
        return offset += (long)fats * sectsPerFat * sectSize;
    }

    public static long getFilesOffset(BootSector bs) {
        long offset = FatUtils.getRootDirOffset(bs);
        return offset += (long)(bs.getRootDirEntryCount() * 32);
    }

    public static String splitName(String nameExt) {
        int i = nameExt.indexOf(46);
        if (i < 0) {
            return nameExt;
        }
        return nameExt.substring(0, i);
    }

    public static String splitExt(String nameExt) {
        int i = nameExt.indexOf(46);
        if (i < 0) {
            return "";
        }
        return nameExt.substring(i + 1);
    }

    public static String normalizeName(String name, String ext) {
        if (ext.length() > 0) {
            return (name + "." + ext).toUpperCase();
        }
        return name.toUpperCase();
    }

    public static String normalizeName(String nameExt) {
        if (nameExt.equals(".")) {
            return nameExt;
        }
        if (nameExt.equals("..")) {
            return nameExt;
        }
        return FatUtils.normalizeName(FatUtils.splitName(nameExt), FatUtils.splitExt(nameExt));
    }

    public static void writeSubString(char[] src, int srcOffset, int ordinal, byte checkSum, boolean isLast, byte[] dest, int destOffset) {
        if (isLast) {
            LittleEndian.setInt8(dest, destOffset, ordinal + 64);
        } else {
            LittleEndian.setInt8(dest, destOffset, ordinal);
        }
        LittleEndian.setInt16(dest, destOffset + 1, src[srcOffset + 0]);
        LittleEndian.setInt16(dest, destOffset + 3, src[srcOffset + 1]);
        LittleEndian.setInt16(dest, destOffset + 5, src[srcOffset + 2]);
        LittleEndian.setInt16(dest, destOffset + 7, src[srcOffset + 3]);
        LittleEndian.setInt16(dest, destOffset + 9, src[srcOffset + 4]);
        LittleEndian.setInt8(dest, destOffset + 11, 15);
        LittleEndian.setInt8(dest, destOffset + 12, 0);
        LittleEndian.setInt8(dest, destOffset + 13, checkSum);
        LittleEndian.setInt16(dest, destOffset + 14, src[srcOffset + 5]);
        LittleEndian.setInt16(dest, destOffset + 16, src[srcOffset + 6]);
        LittleEndian.setInt16(dest, destOffset + 18, src[srcOffset + 7]);
        LittleEndian.setInt16(dest, destOffset + 20, src[srcOffset + 8]);
        LittleEndian.setInt16(dest, destOffset + 22, src[srcOffset + 9]);
        LittleEndian.setInt16(dest, destOffset + 24, src[srcOffset + 10]);
        LittleEndian.setInt16(dest, destOffset + 26, 0);
        LittleEndian.setInt16(dest, destOffset + 28, src[srcOffset + 11]);
        LittleEndian.setInt16(dest, destOffset + 30, src[srcOffset + 12]);
    }

    static char[] getUnicodeChars(byte[] rawData, int offset) {
        char[] unicodechar = new char[]{(char)LittleEndian.getUInt16(rawData, offset + 1), (char)LittleEndian.getUInt16(rawData, offset + 3), (char)LittleEndian.getUInt16(rawData, offset + 5), (char)LittleEndian.getUInt16(rawData, offset + 7), (char)LittleEndian.getUInt16(rawData, offset + 9), (char)LittleEndian.getUInt16(rawData, offset + 14), (char)LittleEndian.getUInt16(rawData, offset + 16), (char)LittleEndian.getUInt16(rawData, offset + 18), (char)LittleEndian.getUInt16(rawData, offset + 20), (char)LittleEndian.getUInt16(rawData, offset + 22), (char)LittleEndian.getUInt16(rawData, offset + 24), (char)LittleEndian.getUInt16(rawData, offset + 28), (char)LittleEndian.getUInt16(rawData, offset + 30)};
        return unicodechar;
    }

    private FatUtils() {
    }
}

