/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.LittleEndian;
import java.util.Arrays;

final class ShortName {
    private static final byte[] ILLEGAL_CHARS = new byte[]{34, 42, 43, 44, 46, 47, 58, 59, 60, 61, 62, 63, 91, 92, 93, 124};
    public static final ShortName DOT = new ShortName(".", "");
    public static final ShortName DOT_DOT = new ShortName("..", "");
    private final char[] name;

    private ShortName(String nameExt) {
        String extString;
        String nameString;
        if (nameExt.length() > 12) {
            throw new IllegalArgumentException("name too long");
        }
        int i = nameExt.indexOf(46);
        if (i < 0) {
            nameString = nameExt.toUpperCase();
            extString = "";
        } else {
            nameString = nameExt.substring(0, i).toUpperCase();
            extString = nameExt.substring(i + 1).toUpperCase();
        }
        this.name = ShortName.toCharArray(nameString, extString);
        ShortName.checkValidChars(this.name);
    }

    ShortName(String name, String ext) {
        this.name = ShortName.toCharArray(name, ext);
    }

    private static char[] toCharArray(String name, String ext) {
        ShortName.checkValidName(name);
        ShortName.checkValidExt(ext);
        char[] result = new char[11];
        Arrays.fill(result, ' ');
        System.arraycopy(name.toCharArray(), 0, result, 0, name.length());
        System.arraycopy(ext.toCharArray(), 0, result, 8, ext.length());
        return result;
    }

    public byte checkSum() {
        byte[] dest = new byte[11];
        for (int i = 0; i < 11; ++i) {
            dest[i] = (byte)this.name[i];
        }
        int sum = dest[0];
        for (int i = 1; i < 11; ++i) {
            sum = dest[i] + (((sum & 1) << 7) + ((sum & 0xFE) >> 1));
        }
        return (byte)(sum & 0xFF);
    }

    public static ShortName get(String name) throws IllegalArgumentException {
        if (name.equals(".")) {
            return DOT;
        }
        if (name.equals("..")) {
            return DOT_DOT;
        }
        return new ShortName(name);
    }

    public static boolean canConvert(String nameExt) {
        try {
            ShortName.get(nameExt);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static ShortName parse(AbstractDirectoryEntry entry) {
        char[] nameArr = new char[8];
        for (int i = 0; i < nameArr.length; ++i) {
            nameArr[i] = (char)LittleEndian.getUInt8(entry.getData(), i);
        }
        if (LittleEndian.getUInt8(entry.getData(), 0) == 5) {
            nameArr[0] = 229;
        }
        char[] extArr = new char[3];
        for (int i = 0; i < extArr.length; ++i) {
            extArr[i] = (char)LittleEndian.getUInt8(entry.getData(), 8 + i);
        }
        return new ShortName(new String(nameArr).trim(), new String(extArr).trim());
    }

    public void write(AbstractDirectoryEntry entry) {
        byte[] dest = entry.getData();
        for (int i = 0; i < 11; ++i) {
            dest[i] = (byte)this.name[i];
        }
        entry.markDirty();
    }

    public String asSimpleString() {
        return new String(this.name).trim();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.asSimpleString() + "]";
    }

    private static void checkValidName(String name) {
        ShortName.checkString(name, "name", 1, 8);
    }

    private static void checkValidExt(String ext) {
        ShortName.checkString(ext, "extension", 0, 3);
    }

    private static void checkString(String str, String strType, int minLength, int maxLength) {
        if (str == null) {
            throw new IllegalArgumentException(strType + " is null");
        }
        if (str.length() < minLength) {
            throw new IllegalArgumentException(strType + " must have at least " + minLength + " characters: " + str);
        }
        if (str.length() > maxLength) {
            throw new IllegalArgumentException(strType + " has more than " + maxLength + " characters: " + str);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortName)) {
            return false;
        }
        ShortName other = (ShortName)obj;
        return Arrays.equals(this.name, other.name);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name);
    }

    public static void checkValidChars(char[] chars) throws IllegalArgumentException {
        if (chars[0] == ' ') {
            throw new IllegalArgumentException("0x20 can not be the first character");
        }
        for (int i = 0; i < chars.length; ++i) {
            if ((chars[i] & 0xFF) != chars[i]) {
                throw new IllegalArgumentException("multi-byte character at " + i);
            }
            byte toTest = (byte)(chars[i] & 0xFF);
            if (toTest < 32 && toTest != 5) {
                throw new IllegalArgumentException("caracter < 0x20 at" + i);
            }
            for (int j = 0; j < ILLEGAL_CHARS.length; ++j) {
                if (toTest != ILLEGAL_CHARS[j]) continue;
                throw new IllegalArgumentException("illegal character " + ILLEGAL_CHARS[j] + " at " + i);
            }
        }
    }
}

