/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.ShortName;
import java.util.Collections;
import java.util.Set;

final class ShortNameGenerator {
    private final Set<ShortName> usedNames;

    public ShortNameGenerator(Set<ShortName> usedNames) {
        this.usedNames = Collections.unmodifiableSet(usedNames);
    }

    public static boolean validChar(char toTest) {
        if (toTest >= 'A' && toTest <= 'Z') {
            return true;
        }
        if (toTest >= '0' && toTest <= '9') {
            return true;
        }
        return toTest == '_' || toTest == '^' || toTest == '$' || toTest == '~' || toTest == '!' || toTest == '#' || toTest == '%' || toTest == '&' || toTest == '-' || toTest == '{' || toTest == '}' || toTest == '(' || toTest == ')' || toTest == '@' || toTest == '\'' || toTest == '`';
    }

    public static boolean isSkipChar(char c) {
        return c == '.' || c == ' ';
    }

    private String tidyString(String dirty) {
        StringBuilder result = new StringBuilder();
        for (int src = 0; src < dirty.length(); ++src) {
            char toTest = Character.toUpperCase(dirty.charAt(src));
            if (ShortNameGenerator.isSkipChar(toTest)) continue;
            if (ShortNameGenerator.validChar(toTest)) {
                result.append(toTest);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    private boolean cleanString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (ShortNameGenerator.isSkipChar(s.charAt(i))) {
                return false;
            }
            if (ShortNameGenerator.validChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String stripLeadingPeriods(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '.') continue;
            sb.append(str.substring(i));
            break;
        }
        return sb.toString();
    }

    public ShortName generateShortName(String longFullName) throws IllegalStateException {
        String shortExt;
        String longExt;
        String longName;
        boolean forceSuffix;
        int dotIdx = (longFullName = this.stripLeadingPeriods(longFullName).toUpperCase()).lastIndexOf(46);
        if (dotIdx == -1) {
            forceSuffix = !this.cleanString(longFullName);
            longName = this.tidyString(longFullName);
            longExt = "";
        } else {
            forceSuffix = !this.cleanString(longFullName.substring(0, dotIdx));
            longName = this.tidyString(longFullName.substring(0, dotIdx));
            longExt = this.tidyString(longFullName.substring(dotIdx + 1));
        }
        String string = shortExt = longExt.length() > 3 ? longExt.substring(0, 3) : longExt;
        if (forceSuffix || longName.length() > 8 || this.usedNames.contains(new ShortName(longName, shortExt))) {
            int maxLongIdx = Math.min(longName.length(), 8);
            for (int i = 1; i < 99999; ++i) {
                String serial = "~" + i;
                int serialLen = serial.length();
                String shortName = longName.substring(0, Math.min(maxLongIdx, 8 - serialLen)) + serial;
                ShortName result = new ShortName(shortName, shortExt);
                if (this.usedNames.contains(result)) continue;
                return result;
            }
            throw new IllegalStateException("could not generate short name for \"" + longFullName + "\"");
        }
        return new ShortName(longName, shortExt);
    }
}

