/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs;

import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.FsObject;
import java.io.IOException;
import java.util.Comparator;

public interface FsDirectoryEntry
extends FsObject {
    public static final Comparator<FsDirectoryEntry> DIRECTORY_ENTRY_COMPARATOR = new Comparator<FsDirectoryEntry>(){

        @Override
        public int compare(FsDirectoryEntry e1, FsDirectoryEntry e2) {
            if (e2.isDirectory() == e1.isDirectory()) {
                return e1.getName().compareTo(e2.getName());
            }
            if (e2.isDirectory()) {
                return 1;
            }
            return -1;
        }
    };

    public String getName();

    public FsDirectory getParent();

    public long getLastModified() throws IOException;

    public long getCreated() throws IOException;

    public long getLastAccessed() throws IOException;

    public boolean isFile();

    public boolean isDirectory();

    public void setName(String var1) throws IOException;

    public void setLastModified(long var1) throws IOException;

    public FsFile getFile() throws IOException;

    public FsDirectory getDirectory() throws IOException;

    public boolean isDirty();
}

