/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.FatObject;
import de.waldheinz.fs.fat.LittleEndian;
import java.io.IOException;

final class AbstractDirectoryEntry
extends FatObject {
    public static final int F_READONLY = 1;
    public static final int F_HIDDEN = 2;
    public static final int F_SYSTEM = 4;
    public static final int F_VOLUME_ID = 8;
    public static final int F_DIRECTORY = 16;
    public static final int F_ARCHIVE = 32;
    public static final int FLAGS_OFFSET = 11;
    public static final int SIZE = 32;
    private final byte[] rawData = new byte[32];
    private final AbstractDirectory dir;
    private boolean dirty;

    public AbstractDirectoryEntry(AbstractDirectory dir) {
        this.dir = dir;
    }

    protected AbstractDirectoryEntry(AbstractDirectory dir, byte[] src, int offset) {
        System.arraycopy(src, offset, this.rawData, 0, 32);
        this.dir = dir;
        this.dirty = false;
    }

    public byte[] getData() {
        return this.rawData;
    }

    public AbstractDirectory getDir() {
        return this.dir;
    }

    public void write(byte[] dest, int offset) {
        System.arraycopy(this.rawData, 0, dest, offset, 32);
        this.dirty = false;
    }

    public int getFlags() {
        return LittleEndian.getUInt8(this.rawData, 11);
    }

    public void setFlags(int flags) {
        LittleEndian.setInt8(this.rawData, 11, flags);
        this.markDirty();
    }

    public boolean isReadOnly() {
        return this.dir.isReadOnly() || this.isReadonlyFlag();
    }

    public boolean isReadonlyFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public void setReadonlyFlag() {
        this.setFlags(this.getFlags() | 1);
    }

    public boolean isHidden() {
        return (this.getFlags() & 2) != 0;
    }

    public void setHidden() {
        this.setFlags(this.getFlags() | 2);
    }

    public boolean isSystem() {
        return (this.getFlags() & 4) != 0;
    }

    public boolean isVolumeLabel() {
        if (this.isLfnEntry()) {
            return false;
        }
        return (this.getFlags() & 0x18) == 8;
    }

    public boolean isLfnEntry() {
        return this.isReadonlyFlag() && this.isSystem() && this.isHidden() && this.isLabel();
    }

    public void setSystem() {
        this.setFlags(this.getFlags() | 4);
    }

    public boolean isLabel() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    public void setDirectory() {
        this.setFlags(16);
    }

    public void setLabel() {
        this.setFlags(8);
    }

    public boolean isFile() {
        return (this.getFlags() & 0x18) == 0;
    }

    public boolean isArchive() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setArchive() {
        this.setFlags(this.getFlags() | 0x20);
    }

    protected void markDirty() {
        this.dirty = true;
        this.dir.setDirty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        for (int i = 0; i < 32; ++i) {
            int val = this.rawData[i] & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
            if (i >= 31) continue;
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    void remove() throws IOException {
        this.dir.removeEntry(this);
    }
}

