/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.AbstractDirectoryEntry;
import de.waldheinz.fs.fat.LittleEndian;

final class FatLfnDirEntry {
    private FatLfnDirEntry() {
    }

    public static void set(AbstractDirectoryEntry entry, String subName, int ordinal, byte checkSum, boolean isLast) {
        char[] unicodechar = new char[13];
        subName.getChars(0, subName.length(), unicodechar, 0);
        for (int i = subName.length(); i < 13; ++i) {
            unicodechar[i] = i == subName.length() ? 0 : 65535;
        }
        byte[] rawData = entry.getData();
        if (isLast) {
            LittleEndian.setInt8(rawData, 0, ordinal + 64);
        } else {
            LittleEndian.setInt8(rawData, 0, ordinal);
        }
        LittleEndian.setInt16(rawData, 1, unicodechar[0]);
        LittleEndian.setInt16(rawData, 3, unicodechar[1]);
        LittleEndian.setInt16(rawData, 5, unicodechar[2]);
        LittleEndian.setInt16(rawData, 7, unicodechar[3]);
        LittleEndian.setInt16(rawData, 9, unicodechar[4]);
        LittleEndian.setInt8(rawData, 11, 15);
        LittleEndian.setInt8(rawData, 12, 0);
        LittleEndian.setInt8(rawData, 13, checkSum);
        LittleEndian.setInt16(rawData, 14, unicodechar[5]);
        LittleEndian.setInt16(rawData, 16, unicodechar[6]);
        LittleEndian.setInt16(rawData, 18, unicodechar[7]);
        LittleEndian.setInt16(rawData, 20, unicodechar[8]);
        LittleEndian.setInt16(rawData, 22, unicodechar[9]);
        LittleEndian.setInt16(rawData, 24, unicodechar[10]);
        LittleEndian.setInt16(rawData, 26, 0);
        LittleEndian.setInt16(rawData, 28, unicodechar[11]);
        LittleEndian.setInt16(rawData, 30, unicodechar[12]);
    }

    public static String getSubstring(AbstractDirectoryEntry entry) {
        int end;
        byte[] rawData = entry.getData();
        char[] unicodechar = new char[]{(char)LittleEndian.getUInt16(rawData, 1), (char)LittleEndian.getUInt16(rawData, 3), (char)LittleEndian.getUInt16(rawData, 5), (char)LittleEndian.getUInt16(rawData, 7), (char)LittleEndian.getUInt16(rawData, 9), (char)LittleEndian.getUInt16(rawData, 14), (char)LittleEndian.getUInt16(rawData, 16), (char)LittleEndian.getUInt16(rawData, 18), (char)LittleEndian.getUInt16(rawData, 20), (char)LittleEndian.getUInt16(rawData, 22), (char)LittleEndian.getUInt16(rawData, 24), (char)LittleEndian.getUInt16(rawData, 28), (char)LittleEndian.getUInt16(rawData, 30)};
        for (end = 0; end < 13 && unicodechar[end] != '\u0000'; ++end) {
        }
        return new String(unicodechar).substring(0, end);
    }
}

