/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.DirectoryFullException;
import de.waldheinz.fs.fat.Fat16BootSector;
import de.waldheinz.fs.fat.FatUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

final class Fat16RootDirectory
extends AbstractDirectory {
    private final BlockDevice device;
    private final long deviceOffset;

    private Fat16RootDirectory(Fat16BootSector bs, boolean readOnly) {
        super(bs.getFatType(), bs.getRootDirEntryCount(), readOnly, true);
        if (bs.getRootDirEntryCount() <= 0) {
            throw new IllegalArgumentException("root directory size is " + bs.getRootDirEntryCount());
        }
        this.deviceOffset = FatUtils.getRootDirOffset(bs);
        this.device = bs.getDevice();
    }

    public static Fat16RootDirectory read(Fat16BootSector bs, boolean readOnly) throws IOException {
        Fat16RootDirectory result = new Fat16RootDirectory(bs, readOnly);
        result.read();
        return result;
    }

    public static Fat16RootDirectory create(Fat16BootSector bs) throws IOException {
        Fat16RootDirectory result = new Fat16RootDirectory(bs, false);
        result.flush();
        return result;
    }

    @Override
    protected void read(ByteBuffer data) throws IOException {
        this.device.read(this.deviceOffset, data);
    }

    @Override
    protected void write(ByteBuffer data) throws IOException {
        this.device.write(this.deviceOffset, data);
    }

    @Override
    protected long getStorageCluster() {
        return 0L;
    }

    @Override
    protected void changeSize(int entryCount) throws DirectoryFullException {
        if (this.getCapacity() < entryCount) {
            throw new DirectoryFullException(this.getCapacity(), entryCount);
        }
    }
}

