/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.fat.DosUtils;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.LittleEndian;
import de.waldheinz.fs.fat.ShortName;
import java.nio.ByteBuffer;

final class FatDirectoryEntry
extends AbstractFsObject {
    public static final int SIZE = 32;
    private static final int OFFSET_ATTRIBUTES = 11;
    private static final int OFFSET_FILE_SIZE = 28;
    private static final int F_READONLY = 1;
    private static final int F_HIDDEN = 2;
    private static final int F_SYSTEM = 4;
    private static final int F_VOLUME_ID = 8;
    private static final int F_DIRECTORY = 16;
    private static final int F_ARCHIVE = 32;
    public static final int ENTRY_DELETED_MAGIC = 229;
    private final byte[] data;
    private final FatType type;
    private boolean dirty;

    FatDirectoryEntry(FatType fs, byte[] data, boolean readOnly) {
        super(readOnly);
        this.data = data;
        this.type = fs;
    }

    private FatDirectoryEntry(FatType fs) {
        this(fs, new byte[32], false);
    }

    public static FatDirectoryEntry read(FatType type, ByteBuffer buff, boolean readOnly) {
        assert (buff.remaining() >= 32);
        if (buff.get(buff.position()) == 0) {
            return null;
        }
        byte[] data = new byte[32];
        buff.get(data);
        return new FatDirectoryEntry(type, data, readOnly);
    }

    public static void writeNullEntry(ByteBuffer buff) {
        for (int i = 0; i < 32; ++i) {
            buff.put((byte)0);
        }
    }

    public boolean isVolumeLabel() {
        if (this.isLfnEntry()) {
            return false;
        }
        return (this.getFlags() & 0x18) == 8;
    }

    private void setFlag(int mask, boolean set) {
        int oldFlags = this.getFlags();
        if ((oldFlags & mask) != 0 == set) {
            return;
        }
        if (set) {
            this.setFlags(oldFlags | mask);
        } else {
            this.setFlags(oldFlags & ~mask);
        }
        this.dirty = true;
    }

    public boolean isSystemFlag() {
        return (this.getFlags() & 4) != 0;
    }

    public void setSystemFlag(boolean isSystem) {
        this.setFlag(4, isSystem);
    }

    public boolean isArchiveFlag() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setArchiveFlag(boolean isArchive) {
        this.setFlag(32, isArchive);
    }

    public boolean isHiddenFlag() {
        return (this.getFlags() & 2) != 0;
    }

    public void setHiddenFlag(boolean isHidden) {
        this.setFlag(2, isHidden);
    }

    public boolean isVolumeIdFlag() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean isLfnEntry() {
        return this.isReadonlyFlag() && this.isSystemFlag() && this.isHiddenFlag() && this.isVolumeIdFlag();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getFlags() {
        return LittleEndian.getUInt8(this.data, 11);
    }

    private void setFlags(int flags) {
        LittleEndian.setInt8(this.data, 11, flags);
    }

    public boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    public static FatDirectoryEntry create(FatType type, boolean directory) {
        FatDirectoryEntry result = new FatDirectoryEntry(type);
        if (directory) {
            result.setFlags(16);
        }
        long now = System.currentTimeMillis();
        result.setCreated(now);
        result.setLastAccessed(now);
        result.setLastModified(now);
        return result;
    }

    public static FatDirectoryEntry createVolumeLabel(FatType type, String volumeLabel) {
        assert (volumeLabel != null);
        byte[] data = new byte[32];
        System.arraycopy(volumeLabel.getBytes(), 0, data, 0, volumeLabel.length());
        FatDirectoryEntry result = new FatDirectoryEntry(type, data, false);
        result.setFlags(8);
        return result;
    }

    public String getVolumeLabel() {
        byte b;
        if (!this.isVolumeLabel()) {
            throw new UnsupportedOperationException("not a volume label");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11 && (b = this.data[i]) != 0; ++i) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public long getCreated() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.data, 16), LittleEndian.getUInt16(this.data, 14));
    }

    public void setCreated(long created) {
        LittleEndian.setInt16(this.data, 14, DosUtils.encodeTime(created));
        LittleEndian.setInt16(this.data, 16, DosUtils.encodeDate(created));
        this.dirty = true;
    }

    public long getLastModified() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.data, 24), LittleEndian.getUInt16(this.data, 22));
    }

    public void setLastModified(long lastModified) {
        LittleEndian.setInt16(this.data, 22, DosUtils.encodeTime(lastModified));
        LittleEndian.setInt16(this.data, 24, DosUtils.encodeDate(lastModified));
        this.dirty = true;
    }

    public long getLastAccessed() {
        return DosUtils.decodeDateTime(LittleEndian.getUInt16(this.data, 18), 0);
    }

    public void setLastAccessed(long lastAccessed) {
        LittleEndian.setInt16(this.data, 18, DosUtils.encodeDate(lastAccessed));
        this.dirty = true;
    }

    public boolean isDeleted() {
        return LittleEndian.getUInt8(this.data, 0) == 229;
    }

    public long getLength() {
        return LittleEndian.getUInt32(this.data, 28);
    }

    public void setLength(long length) throws IllegalArgumentException {
        LittleEndian.setInt32(this.data, 28, length);
    }

    public ShortName getShortName() {
        if (this.data[0] == 0) {
            return null;
        }
        return ShortName.parse(this.data);
    }

    public boolean isFile() {
        return (this.getFlags() & 0x18) == 0;
    }

    public void setShortName(ShortName sn) {
        if (sn.equals(this.getShortName())) {
            return;
        }
        sn.write(this.data);
        this.dirty = true;
    }

    public long getStartCluster() {
        if (this.type == FatType.FAT32) {
            return LittleEndian.getUInt16(this.data, 20) << 16 | LittleEndian.getUInt16(this.data, 26);
        }
        return LittleEndian.getUInt16(this.data, 26);
    }

    void setStartCluster(long startCluster) {
        if (startCluster > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (this.type == FatType.FAT32) {
            LittleEndian.setInt16(this.data, 26, (int)(startCluster & 0xFFFFL));
            LittleEndian.setInt16(this.data, 20, (int)(startCluster >> 16 & 0xFFFFL));
        } else {
            LittleEndian.setInt16(this.data, 26, (int)startCluster);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getShortName() + "]";
    }

    void write(ByteBuffer buff) {
        buff.put(this.data);
        this.dirty = false;
    }

    public boolean isReadonlyFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public void setReadonlyFlag(boolean isReadonly) {
        this.setFlag(1, isReadonly);
    }

    String getLfnPart() {
        int end;
        char[] unicodechar = new char[]{(char)LittleEndian.getUInt16(this.data, 1), (char)LittleEndian.getUInt16(this.data, 3), (char)LittleEndian.getUInt16(this.data, 5), (char)LittleEndian.getUInt16(this.data, 7), (char)LittleEndian.getUInt16(this.data, 9), (char)LittleEndian.getUInt16(this.data, 14), (char)LittleEndian.getUInt16(this.data, 16), (char)LittleEndian.getUInt16(this.data, 18), (char)LittleEndian.getUInt16(this.data, 20), (char)LittleEndian.getUInt16(this.data, 22), (char)LittleEndian.getUInt16(this.data, 24), (char)LittleEndian.getUInt16(this.data, 28), (char)LittleEndian.getUInt16(this.data, 30)};
        for (end = 0; end < 13 && unicodechar[end] != '\u0000'; ++end) {
        }
        return new String(unicodechar).substring(0, end);
    }
}

