/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.FatDirectoryEntry;
import de.waldheinz.fs.fat.FatFile;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.LittleEndian;
import de.waldheinz.fs.fat.ShortName;
import java.io.IOException;

public final class FatLfnDirectoryEntry
extends AbstractFsObject
implements FsDirectoryEntry {
    final FatDirectoryEntry realEntry;
    private FatLfnDirectory parent;
    private String fileName;

    FatLfnDirectoryEntry(String name, ShortName sn, FatLfnDirectory parent, boolean directory) {
        super(false);
        this.parent = parent;
        this.fileName = name;
        long now = System.currentTimeMillis();
        this.realEntry = FatDirectoryEntry.create(parent.getFat().getFatType(), directory);
        this.realEntry.setShortName(sn);
        this.realEntry.setCreated(now);
        this.realEntry.setLastAccessed(now);
    }

    FatLfnDirectoryEntry(FatLfnDirectory parent, FatDirectoryEntry realEntry, String fileName) {
        super(parent.isReadOnly());
        this.parent = parent;
        this.realEntry = realEntry;
        this.fileName = fileName;
    }

    static FatLfnDirectoryEntry extract(FatLfnDirectory dir, int offset, int len) {
        String fileName;
        FatDirectoryEntry realEntry = dir.dir.getEntry(offset + len - 1);
        if (len == 1) {
            fileName = realEntry.getShortName().asSimpleString();
        } else {
            StringBuilder name = new StringBuilder(13 * (len - 1));
            for (int i = len - 2; i >= 0; --i) {
                FatDirectoryEntry entry = dir.dir.getEntry(i + offset);
                name.append(entry.getLfnPart());
            }
            fileName = name.toString().trim();
        }
        return new FatLfnDirectoryEntry(dir, realEntry, fileName);
    }

    public boolean isHiddenFlag() {
        return this.realEntry.isHiddenFlag();
    }

    public void setHiddenFlag(boolean hidden) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setHiddenFlag(hidden);
    }

    public boolean isSystemFlag() {
        return this.realEntry.isSystemFlag();
    }

    public void setSystemFlag(boolean systemEntry) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setSystemFlag(systemEntry);
    }

    public boolean isReadOnlyFlag() {
        return this.realEntry.isReadonlyFlag();
    }

    public void setReadOnlyFlag(boolean readOnly) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setReadonlyFlag(readOnly);
    }

    public boolean isArchiveFlag() {
        return this.realEntry.isArchiveFlag();
    }

    public void setArchiveFlag(boolean archive) throws ReadOnlyException {
        this.checkWritable();
        this.realEntry.setArchiveFlag(archive);
    }

    private int totalEntrySize() {
        int result = this.fileName.length() / 13 + 1;
        if (this.fileName.length() % 13 != 0) {
            ++result;
        }
        return result;
    }

    FatDirectoryEntry[] compactForm() {
        if (this.realEntry.getShortName().equals(ShortName.DOT) || this.realEntry.getShortName().equals(ShortName.DOT_DOT)) {
            return new FatDirectoryEntry[]{this.realEntry};
        }
        int totalEntrySize = this.totalEntrySize();
        FatDirectoryEntry[] entries = new FatDirectoryEntry[totalEntrySize];
        byte checkSum = this.realEntry.getShortName().checkSum();
        int j = 0;
        FatType type = this.parent.getFat().getFatType();
        for (int i = totalEntrySize - 2; i > 0; --i) {
            entries[i] = FatLfnDirectoryEntry.createPart(type, this.fileName.substring(j * 13, j * 13 + 13), j + 1, checkSum, false);
            ++j;
        }
        entries[0] = FatLfnDirectoryEntry.createPart(type, this.fileName.substring(j * 13), j + 1, checkSum, true);
        entries[totalEntrySize - 1] = this.realEntry;
        return entries;
    }

    @Override
    public String getName() {
        this.checkValid();
        return this.fileName;
    }

    @Override
    public FsDirectory getParent() {
        this.checkValid();
        return this.parent;
    }

    @Override
    public void setName(String newName) throws IOException {
        this.checkWritable();
        if (!this.parent.isFreeName(newName)) {
            throw new IOException("the name \"" + newName + "\" is already in use");
        }
        this.parent.unlinkEntry(this);
        this.fileName = newName;
        this.parent.linkEntry(this);
    }

    public void moveTo(FatLfnDirectory target, String newName) throws IOException, ReadOnlyException {
        this.checkWritable();
        if (!target.isFreeName(newName)) {
            throw new IOException("the name \"" + newName + "\" is already in use");
        }
        this.parent.unlinkEntry(this);
        this.parent = target;
        this.fileName = newName;
        this.parent.linkEntry(this);
    }

    @Override
    public void setLastModified(long lastModified) {
        this.checkWritable();
        this.realEntry.setLastModified(lastModified);
    }

    @Override
    public FatFile getFile() throws IOException {
        return this.parent.getFile(this.realEntry);
    }

    @Override
    public FatLfnDirectory getDirectory() throws IOException {
        return this.parent.getDirectory(this.realEntry);
    }

    public String toString() {
        return "LFN = " + this.fileName + " / SFN = " + this.realEntry.getShortName();
    }

    private static FatDirectoryEntry createPart(FatType type, String subName, int ordinal, byte checkSum, boolean isLast) {
        char[] unicodechar = new char[13];
        subName.getChars(0, subName.length(), unicodechar, 0);
        for (int i = subName.length(); i < 13; ++i) {
            unicodechar[i] = i == subName.length() ? 0 : 65535;
        }
        byte[] rawData = new byte[32];
        if (isLast) {
            LittleEndian.setInt8(rawData, 0, ordinal + 64);
        } else {
            LittleEndian.setInt8(rawData, 0, ordinal);
        }
        LittleEndian.setInt16(rawData, 1, unicodechar[0]);
        LittleEndian.setInt16(rawData, 3, unicodechar[1]);
        LittleEndian.setInt16(rawData, 5, unicodechar[2]);
        LittleEndian.setInt16(rawData, 7, unicodechar[3]);
        LittleEndian.setInt16(rawData, 9, unicodechar[4]);
        LittleEndian.setInt8(rawData, 11, 15);
        LittleEndian.setInt8(rawData, 12, 0);
        LittleEndian.setInt8(rawData, 13, checkSum & 0xFF);
        LittleEndian.setInt16(rawData, 14, unicodechar[5]);
        LittleEndian.setInt16(rawData, 16, unicodechar[6]);
        LittleEndian.setInt16(rawData, 18, unicodechar[7]);
        LittleEndian.setInt16(rawData, 20, unicodechar[8]);
        LittleEndian.setInt16(rawData, 22, unicodechar[9]);
        LittleEndian.setInt16(rawData, 24, unicodechar[10]);
        LittleEndian.setInt16(rawData, 26, 0);
        LittleEndian.setInt16(rawData, 28, unicodechar[11]);
        LittleEndian.setInt16(rawData, 30, unicodechar[12]);
        return new FatDirectoryEntry(type, rawData, false);
    }

    @Override
    public long getLastModified() throws IOException {
        return this.realEntry.getLastModified();
    }

    @Override
    public long getCreated() throws IOException {
        return this.realEntry.getCreated();
    }

    @Override
    public long getLastAccessed() throws IOException {
        return this.realEntry.getLastAccessed();
    }

    @Override
    public boolean isFile() {
        return this.realEntry.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.realEntry.isDirectory();
    }

    @Override
    public boolean isDirty() {
        return this.realEntry.isDirty();
    }
}

