/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.LittleEndian;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;

final class ShortName {
    public static final Charset ASCII = Charset.forName("ASCII");
    private static final byte[] ILLEGAL_CHARS = new byte[]{34, 42, 43, 44, 46, 47, 58, 59, 60, 61, 62, 63, 91, 92, 93, 124};
    private static final byte ASCII_SPACE = 32;
    public static final ShortName DOT = new ShortName(".", "");
    public static final ShortName DOT_DOT = new ShortName("..", "");
    private final byte[] nameBytes;

    private ShortName(String nameExt) {
        String extString;
        String nameString;
        if (nameExt.length() > 12) {
            throw new IllegalArgumentException("name too long");
        }
        int i = nameExt.indexOf(46);
        if (i < 0) {
            nameString = nameExt.toUpperCase(Locale.ROOT);
            extString = "";
        } else {
            nameString = nameExt.substring(0, i).toUpperCase(Locale.ROOT);
            extString = nameExt.substring(i + 1).toUpperCase(Locale.ROOT);
        }
        this.nameBytes = ShortName.toCharArray(nameString, extString);
        ShortName.checkValidChars(this.nameBytes);
    }

    ShortName(String name, String ext) {
        this.nameBytes = ShortName.toCharArray(name, ext);
    }

    private static byte[] toCharArray(String name, String ext) {
        ShortName.checkValidName(name);
        ShortName.checkValidExt(ext);
        byte[] result = new byte[11];
        Arrays.fill(result, (byte)32);
        System.arraycopy(name.getBytes(ASCII), 0, result, 0, name.length());
        System.arraycopy(ext.getBytes(ASCII), 0, result, 8, ext.length());
        return result;
    }

    public byte checkSum() {
        byte[] dest = new byte[11];
        for (int i = 0; i < 11; ++i) {
            dest[i] = this.nameBytes[i];
        }
        int sum = dest[0];
        for (int i = 1; i < 11; ++i) {
            sum = dest[i] + (((sum & 1) << 7) + ((sum & 0xFE) >> 1));
        }
        return (byte)(sum & 0xFF);
    }

    public static ShortName get(String name) throws IllegalArgumentException {
        if (name.equals(".")) {
            return DOT;
        }
        if (name.equals("..")) {
            return DOT_DOT;
        }
        return new ShortName(name);
    }

    public static boolean canConvert(String nameExt) {
        try {
            ShortName.get(nameExt);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static ShortName parse(byte[] data) {
        char[] nameArr = new char[8];
        for (int i = 0; i < nameArr.length; ++i) {
            nameArr[i] = (char)LittleEndian.getUInt8(data, i);
        }
        if (LittleEndian.getUInt8(data, 0) == 5) {
            nameArr[0] = 229;
        }
        char[] extArr = new char[3];
        for (int i = 0; i < extArr.length; ++i) {
            extArr[i] = (char)LittleEndian.getUInt8(data, 8 + i);
        }
        return new ShortName(new String(nameArr).trim(), new String(extArr).trim());
    }

    public void write(byte[] dest) {
        System.arraycopy(this.nameBytes, 0, dest, 0, this.nameBytes.length);
    }

    public String asSimpleString() {
        String name = new String(this.nameBytes, 0, 8, ASCII).trim();
        String ext = new String(this.nameBytes, 8, 3, ASCII).trim();
        return ext.isEmpty() ? name : name + "." + ext;
    }

    public String toString() {
        return "ShortName [" + this.asSimpleString() + "]";
    }

    private static void checkValidName(String name) {
        ShortName.checkString(name, "name", 1, 8);
    }

    private static void checkValidExt(String ext) {
        ShortName.checkString(ext, "extension", 0, 3);
    }

    private static void checkString(String str, String strType, int minLength, int maxLength) {
        if (str == null) {
            throw new IllegalArgumentException(strType + " is null");
        }
        if (str.length() < minLength) {
            throw new IllegalArgumentException(strType + " must have at least " + minLength + " characters: " + str);
        }
        if (str.length() > maxLength) {
            throw new IllegalArgumentException(strType + " has more than " + maxLength + " characters: " + str);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortName)) {
            return false;
        }
        ShortName other = (ShortName)obj;
        return Arrays.equals(this.nameBytes, other.nameBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.nameBytes);
    }

    public static void checkValidChars(byte[] chars) throws IllegalArgumentException {
        if (chars[0] == 32) {
            throw new IllegalArgumentException("0x20 can not be the first character");
        }
        for (int i = 0; i < chars.length; ++i) {
            if ((chars[i] & 0xFF) != chars[i]) {
                throw new IllegalArgumentException("multi-byte character at " + i);
            }
            byte toTest = (byte)(chars[i] & 0xFF);
            if (toTest < 32 && toTest != 5) {
                throw new IllegalArgumentException("caracter < 0x20 at" + i);
            }
            for (int j = 0; j < ILLEGAL_CHARS.length; ++j) {
                if (toTest != ILLEGAL_CHARS[j]) continue;
                throw new IllegalArgumentException("illegal character " + ILLEGAL_CHARS[j] + " at " + i);
            }
        }
    }
}

