package de.weltraumschaf.speakingurl;

/**
 * Supported languages for symbol translations.
 *
 * @since 1.0.0
 * @author Sascha Droste <pid@posteo.net>
 * @author Sven Strittmatter <weltraumschaf@googlemail.com>
 */
public enum Language {
    /**
     * For no symbol translation.
     */
    NONE,
    /**
     * For 'ar' locale.
     */
    ARABIC,
    /**
     * For 'de' locale.
     */
    GERMAN,
    /**
     * For 'nl' locale.
     */
    NETHERLAND,
    /**
     * For 'en' locale.
     */
    ENGLISH,
    /**
     * For 'es' locale.
     */
    SPANISH,
    /**
     * For 'fr' locale.
     */
    FRENCH,
    /**
     * For 'pt' locale.
     */
    PORTUGUESE,
    /**
     * For 'ru' locale.
     */
    RUSSIAN,
    /**
     * For 'cz' locale.
     */
    CZECH,
    /**
     * For 'sk' locale.
     */
    SWEDISH,
    /**
     * For 'vn' locale.
     */
    VIETNAMESE;
}
