/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

import de.weltraumschaf.speakingurl.Language;
import de.weltraumschaf.speakingurl.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class Options {
    private static final String DEFAULT_SEPARATOR = "-";
    private static final Language DEFAULT_LANG = Language.ENGLISH;
    private static final boolean DEFAULT_MAINTAIN_CASE = false;
    private static final boolean DEFAULT_TITLE_CASE = false;
    private static final Set<String> DEFAULT_TITLE_CASE_EXCLUDES = Collections.emptySet();
    private static final int DEFAULT_TRUNCATE = 0;
    private static final boolean DEFAULT_URIC = false;
    private static final boolean DEFAULT_URIC_WITHOUT_SLASH = false;
    private static final boolean DEFAULT_MARK = false;
    private static final Map<String, String> DEFAULT_CUSTOM = new HashMap<String, String>();
    private final Validator validator = new Validator();
    private String separator = "-";
    private Language language = DEFAULT_LANG;
    private boolean maintainCase = false;
    private boolean titleCase = false;
    private Set<String> titleCaseExclude = DEFAULT_TITLE_CASE_EXCLUDES;
    private int truncate = 0;
    private boolean uric = false;
    private boolean uricWithoutSlash = false;
    private boolean mark = false;
    private Map<String, String> custom = DEFAULT_CUSTOM;

    Options() {
    }

    String separator() {
        return this.separator;
    }

    void separator(String withSeparator) {
        this.separator = this.validator.notEmpty(withSeparator, "withSeparator");
    }

    Language language() {
        return this.language;
    }

    void language(Language withLanguage) {
        this.language = this.validator.notNull(withLanguage, "withLanguage");
    }

    boolean maintainCase() {
        return this.maintainCase;
    }

    void maintainCase(boolean withMaintainCase) {
        this.maintainCase = withMaintainCase;
    }

    boolean titleCase() {
        return this.titleCase;
    }

    void titleCase(boolean withTitleCase) {
        this.titleCase = withTitleCase;
    }

    Set<String> titleCaseExclude() {
        return Collections.unmodifiableSet(this.titleCaseExclude);
    }

    void titleCaseExclude(Set<String> withTitleCaseExclude) {
        this.titleCaseExclude = this.validator.notNull(new HashSet<String>(withTitleCaseExclude), "withTitleCaseExclude");
    }

    int truncate() {
        return this.truncate;
    }

    void truncate(int withTruncate) {
        this.truncate = this.validator.notNegative(withTruncate, "withTruncate");
    }

    boolean uric() {
        return this.uric;
    }

    void uric(boolean withUric) {
        this.uric = withUric;
    }

    boolean uricWithoutSlash() {
        return this.uricWithoutSlash;
    }

    void uricWithoutSlash(boolean withUricAndSlash) {
        this.uricWithoutSlash = withUricAndSlash;
    }

    boolean mark() {
        return this.mark;
    }

    void mark(boolean withMark) {
        this.mark = withMark;
    }

    Map<String, String> custom() {
        return Collections.unmodifiableMap(this.custom);
    }

    void custom(Map<String, String> withCustom) {
        this.custom = new HashMap<String, String>(this.validator.notNull(withCustom, "withCustom"));
    }

    Options copy() {
        Options copy = new Options();
        copy.separator = this.separator;
        copy.language = this.language;
        copy.maintainCase = this.maintainCase;
        copy.titleCase = this.titleCase;
        copy.titleCaseExclude = this.titleCaseExclude;
        copy.truncate = this.truncate;
        copy.uric = this.uric;
        copy.uricWithoutSlash = this.uricWithoutSlash;
        copy.mark = this.mark;
        copy.custom = this.custom;
        return copy;
    }

    void resetToDefaults() {
        this.separator = DEFAULT_SEPARATOR;
        this.language = DEFAULT_LANG;
        this.maintainCase = false;
        this.titleCase = false;
        this.titleCaseExclude = DEFAULT_TITLE_CASE_EXCLUDES;
        this.truncate = 0;
        this.uric = false;
        this.uricWithoutSlash = false;
        this.mark = false;
        this.custom = DEFAULT_CUSTOM;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.separator, this.language, this.maintainCase, this.titleCase, this.titleCaseExclude, this.truncate, this.uric, this.uricWithoutSlash, this.mark, this.custom});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Objects.equals(this.separator, other.separator) && Objects.equals((Object)this.language, (Object)other.language) && Objects.equals(this.maintainCase, other.maintainCase) && Objects.equals(this.titleCase, other.titleCase) && Objects.equals(this.titleCaseExclude, other.titleCaseExclude) && Objects.equals(this.truncate, other.truncate) && Objects.equals(this.uric, other.uric) && Objects.equals(this.uricWithoutSlash, other.uricWithoutSlash) && Objects.equals(this.mark, other.mark) && Objects.equals(this.custom, other.custom);
    }

    public String toString() {
        return "void{separator=" + this.separator + ", lang=" + (Object)((Object)this.language) + ", maintainCase=" + this.maintainCase + ", titleCase=" + this.titleCase + ", titleCaseExclude=" + this.titleCaseExclude + ", truncate=" + this.truncate + ", uric=" + this.uric + ", uricNoSlash=" + this.uricWithoutSlash + ", mark=" + this.mark + ", custom=" + this.custom + '}';
    }
}

