/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

import de.weltraumschaf.speakingurl.CharacterMappper;
import de.weltraumschaf.speakingurl.Language;
import de.weltraumschaf.speakingurl.LanguageCharacterMapper;
import de.weltraumschaf.speakingurl.Options;
import de.weltraumschaf.speakingurl.Slug;
import de.weltraumschaf.speakingurl.SymbolMapper;
import de.weltraumschaf.speakingurl.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SlugImplementation
implements Slug {
    private static final String URIC_WITHOUT_SLASH = ";?:@&=+$,";
    private static final String URIC_SLASH = "/";
    private static final String MARK = ".!~*'()";
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("[a-zA-Z0-9]");
    private static final Pattern TITLE = Pattern.compile("(\\w\\S*)");
    private final Validator validator = new Validator();
    private final CharacterMappper characterMapper = new CharacterMappper();
    private final Options options;

    SlugImplementation() {
        this(new Options());
    }

    SlugImplementation(Options options) {
        this.options = this.validator.notNull(options, "options");
    }

    @Override
    public String separator() {
        return this.options.separator();
    }

    @Override
    public Language lang() {
        return this.options.language();
    }

    @Override
    public boolean maintainCase() {
        return this.options.maintainCase();
    }

    @Override
    public boolean titleCase() {
        return this.options.titleCase();
    }

    @Override
    public Set<String> titleCaseExclude() {
        return this.options.titleCaseExclude();
    }

    @Override
    public int truncate() {
        return this.options.truncate();
    }

    @Override
    public boolean uric() {
        return this.options.uric();
    }

    @Override
    public boolean uricNoSlash() {
        return this.options.uricWithoutSlash();
    }

    @Override
    public boolean mark() {
        return this.options.mark();
    }

    @Override
    public Map<String, String> getCustom() {
        return this.options.custom();
    }

    @Override
    public String get(String input) {
        return this.get(input, this.options.separator());
    }

    @Override
    public String get(String rawInput, String separator) {
        if (null == rawInput) {
            return "";
        }
        if (rawInput.trim().isEmpty()) {
            return "";
        }
        HashMap<String, String> customReplacements = new HashMap<String, String>(this.options.custom());
        if (this.options.titleCase()) {
            for (String titleCaseExclude : this.options.titleCaseExclude()) {
                customReplacements.put(titleCaseExclude, titleCaseExclude);
            }
        }
        String allowedChars = this.generateAllowedCharatcers(separator);
        String input = rawInput.trim();
        for (Map.Entry entry : customReplacements.entrySet()) {
            String pattern = ((String)entry.getKey()).length() > 1 ? "\\b" + Pattern.quote((String)entry.getKey()) + "\\b" : Pattern.quote((String)entry.getKey());
            input = input.replaceAll(pattern, (String)entry.getValue());
        }
        if (this.options.titleCase()) {
            input = this.transformCase(input, customReplacements);
        }
        String result = this.processByCharacters(input, separator, allowedChars);
        result = this.cleanupReplacements(result, separator);
        if (this.options.truncate() > 0 && result.length() > this.options.truncate()) {
            boolean lucky = separator.equals(result.charAt(this.options.truncate()) + "");
            result = result.substring(0, this.options.truncate());
            if (!lucky) {
                result = result.substring(0, result.lastIndexOf(separator));
            }
        }
        if (!this.options.maintainCase() && !this.options.titleCase() && this.options.titleCaseExclude().isEmpty()) {
            result = result.toLowerCase();
        }
        return result;
    }

    private String processByCharacters(String input, String separator, String allowedChars) {
        StringBuilder result = new StringBuilder();
        boolean lastCharWasSymbol = false;
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            String ch = this.currentCharacter(input, i);
            if (new LanguageCharacterMapper().knowsCharacter(this.options.language(), ch)) {
                ch = this.replaceLanguageCharacters(lastCharWasSymbol, ch);
                lastCharWasSymbol = false;
            } else if (this.characterMapper.knowsCharacter(ch)) {
                ch = this.replaceCharacters(ch, lastCharWasSymbol);
                lastCharWasSymbol = false;
            } else if (!(!new SymbolMapper().knowsSymbol(this.options.language(), ch) || this.options.uric() && ";?:@&=+$,/".contains(ch) || this.options.uricWithoutSlash() && URIC_WITHOUT_SLASH.contains(ch) || this.options.mark() && MARK.contains(ch))) {
                ch = this.replaceSymbols(ch, lastCharWasSymbol, result.toString(), separator, input, i);
                lastCharWasSymbol = true;
            } else {
                if (i > 0) {
                    String lastResultChar = result.substring(result.length() - 1);
                    if (lastCharWasSymbol && (ALPHA_NUMERIC.matcher(ch).matches() || Pattern.compile("a-zA-Z0-9]").matcher(lastResultChar).matches())) {
                        ch = " " + ch;
                    }
                }
                lastCharWasSymbol = false;
            }
            result.append(this.replaceNotAllowedCharacters(ch, allowedChars, separator));
        }
        return result.toString();
    }

    String generateAllowedCharatcers(String separator) {
        StringBuilder allowedChars = new StringBuilder();
        allowedChars.append(this.validator.notEmpty(separator, "separator"));
        if (this.options.uricWithoutSlash() || this.options.uric()) {
            allowedChars.append(URIC_WITHOUT_SLASH);
        }
        if (this.options.uric()) {
            allowedChars.append(URIC_SLASH);
        }
        if (this.options.mark()) {
            allowedChars.append(MARK);
        }
        return Pattern.quote(allowedChars.toString());
    }

    String currentCharacter(String input, int position) {
        this.validator.notNull(input, "input");
        this.validator.notNegative(position, "index");
        return input.substring(position, position + 1);
    }

    String replaceSymbols(String ch, boolean lastCharWasSymbol, String result, String separator, String input, int currentPos) {
        char nextChar;
        int nextPos;
        int prevPos;
        if (ch == null) {
            return "";
        }
        if (ch.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (null != result && (prevPos = result.length() - 1) >= 0) {
            String lastChar = result.substring(prevPos);
            if (lastCharWasSymbol || ALPHA_NUMERIC.matcher(lastChar).matches()) {
                buffer.append(separator);
            }
        }
        buffer.append(new SymbolMapper().mapSymbol(this.options.language(), ch));
        if (input != null && (nextPos = currentPos + 1) < input.length() && ALPHA_NUMERIC.matcher(String.valueOf(nextChar = input.charAt(nextPos))).matches()) {
            buffer.append(separator);
        }
        return buffer.toString();
    }

    String replaceCharacters(String ch, boolean lastCharWasSymbol) {
        if (ch == null) {
            return "";
        }
        if (ch.isEmpty()) {
            return "";
        }
        if (lastCharWasSymbol && ALPHA_NUMERIC.matcher(this.characterMapper.mapCharacter(ch)).matches()) {
            return " " + this.characterMapper.mapCharacter(ch);
        }
        return this.characterMapper.mapCharacter(ch);
    }

    String replaceLanguageCharacters(boolean lastCharWasSymbol, String ch) {
        String replacement;
        if (ch == null) {
            return "";
        }
        if (ch.isEmpty()) {
            return "";
        }
        String string = replacement = new LanguageCharacterMapper().knowsCharacter(this.options.language(), ch) ? new LanguageCharacterMapper().mapCharacter(this.options.language(), ch) : ch;
        if (lastCharWasSymbol && ALPHA_NUMERIC.matcher(replacement).matches()) {
            return " " + replacement;
        }
        return replacement;
    }

    String replaceNotAllowedCharacters(String ch, String allowedChars, String separator) {
        return ch.replaceAll("[^\\w\\s" + allowedChars + "_\\-]", separator);
    }

    String cleanupReplacements(String input, String separator) {
        String tmp = this.replaceWhitespaces(input, separator);
        tmp = this.replaceDuplicateSeparators(tmp, separator);
        return this.replaceLeadingAndTrailingSeparator(tmp, separator);
    }

    String replaceWhitespaces(String input, String separator) {
        return input.replaceAll("\\s+", separator);
    }

    String replaceDuplicateSeparators(String input, String separator) {
        return input.replaceAll(Pattern.quote(separator) + "+", separator);
    }

    String replaceLeadingAndTrailingSeparator(String input, String separator) {
        return input.replaceAll("(^" + Pattern.quote(separator) + "+" + "|" + Pattern.quote(separator) + "+$)", "");
    }

    String transformCase(String input, Map<String, String> exclusiions) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        Pattern pattern = TITLE;
        Matcher matcher = pattern.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String match = this.ucfirst(matcher.group());
            if (null != exclusiions && exclusiions.containsKey(match.toLowerCase())) {
                matcher.appendReplacement(buffer, match.toLowerCase());
                continue;
            }
            matcher.appendReplacement(buffer, match);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    String ucfirst(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        char[] chars = new char[1];
        input.getChars(0, 1, chars, 0);
        if (Character.isUpperCase(chars[0])) {
            return input;
        }
        StringBuilder buffer = new StringBuilder(input.length());
        buffer.append(Character.toUpperCase(chars[0]));
        buffer.append(input.toCharArray(), 1, input.length() - 1);
        return buffer.toString();
    }
}

