/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.version.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class Artifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final long timestamp;
    private final String name;
    private final String description;
    private final String url;

    public Artifact(String groupId, String artifactId, String version, long timestamp, String name) {
        this(groupId, artifactId, version, timestamp, name, null, null);
    }

    public String formatTimestamp(String format, TimeZone zone) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(zone);
        Date date = new Date(this.timestamp);
        return formatter.format(date);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Artifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ")";
    }

    public Artifact(String groupId, String artifactId, String version, long timestamp, String name, String description, String url) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.timestamp = timestamp;
        this.name = name;
        this.description = description;
        this.url = url;
    }
}

