/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.version.service;

import de.westemeyer.version.model.Artifact;
import de.westemeyer.version.model.DefaultArtifactComparator;
import de.westemeyer.version.service.ArtifactConsumer;
import de.westemeyer.version.service.ArtifactVersionService;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;

public class ArtifactVersionCollector {
    private final Comparator<Artifact> sortingComparator;

    public ArtifactVersionCollector() {
        this(new DefaultArtifactComparator());
    }

    public ArtifactVersionCollector(Comparator<Artifact> sortingComparator) {
        this.sortingComparator = sortingComparator;
    }

    public static Set<Artifact> collectArtifacts() {
        return new ArtifactVersionCollector().collect();
    }

    public Set<Artifact> collect() {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>(this.sortingComparator);
        ArtifactVersionCollector.iterateArtifacts(artifact -> {
            artifacts.add(artifact);
            return false;
        });
        return artifacts;
    }

    public static Artifact findArtifact(String groupId, String artifactId) {
        return ArtifactVersionCollector.iterateArtifacts(artifact -> groupId != null && groupId.equals(artifact.getGroupId()) && artifactId != null && artifactId.equals(artifact.getArtifactId()));
    }

    public static Set<Artifact> findArtifactsByGroupId(String groupId, boolean exact) {
        return new ArtifactVersionCollector().artifactsByGroupId(groupId, exact);
    }

    public Set<Artifact> artifactsByGroupId(String groupId, boolean exact) {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>(this.sortingComparator);
        ArtifactVersionCollector.iterateArtifacts(artifact -> {
            String artifactGroupId = artifact.getGroupId();
            if (groupId == null && !exact || exact && artifactGroupId.equals(groupId) || !exact && artifactGroupId.startsWith(groupId)) {
                artifacts.add(artifact);
            }
            return false;
        });
        return artifacts;
    }

    public static Artifact iterateArtifacts(ArtifactConsumer consumer) {
        ServiceLoader<ArtifactVersionService> serviceLoader = ServiceLoader.load(ArtifactVersionService.class);
        for (ArtifactVersionService versionService : serviceLoader) {
            Artifact artifact = versionService.getArtifact();
            if (!consumer.handleArtifact(artifact)) continue;
            return artifact;
        }
        return null;
    }
}

