/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.countryboundaries;

import de.westnordost.countryboundaries.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

class CountryAreas {
    final String id;
    private final Point[][] outer;
    private final Point[][] inner;

    CountryAreas(String id, Point[][] outer, Point[][] inner) {
        this.id = id;
        this.outer = outer;
        this.inner = inner;
    }

    boolean covers(Point point) {
        int insides = 0;
        for (Point[] area : this.outer) {
            if (!CountryAreas.isPointInPolygon(point, area)) continue;
            ++insides;
        }
        for (Point[] area : this.inner) {
            if (!CountryAreas.isPointInPolygon(point, area)) continue;
            --insides;
        }
        return insides > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryAreas that = (CountryAreas)o;
        return this.id.equals(that.id) && Arrays.deepEquals((Object[])this.inner, (Object[])that.inner) && Arrays.deepEquals((Object[])this.outer, (Object[])that.outer);
    }

    public int hashCode() {
        return 31 * (31 * this.id.hashCode() + Arrays.deepHashCode((Object[])this.outer)) + Arrays.deepHashCode((Object[])this.inner);
    }

    public String toString() {
        return "" + this.id + ":" + Arrays.deepToString((Object[])this.outer) + " - " + Arrays.deepToString((Object[])this.inner);
    }

    void write(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.outer.length);
        for (Point[] ring : this.outer) {
            this.writeRing(ring, out);
        }
        out.writeInt(this.inner.length);
        for (Point[] ring : this.inner) {
            this.writeRing(ring, out);
        }
    }

    private void writeRing(Point[] points, ObjectOutputStream out) throws IOException {
        out.writeInt(points.length);
        for (Point point : points) {
            point.write(out);
        }
    }

    static CountryAreas read(ObjectInputStream in) throws IOException {
        String id = in.readUTF().intern();
        Point[][] outer = new Point[in.readInt()][];
        for (int i = 0; i < outer.length; ++i) {
            outer[i] = CountryAreas.readRing(in);
        }
        Point[][] inner = new Point[in.readInt()][];
        for (int i = 0; i < inner.length; ++i) {
            inner[i] = CountryAreas.readRing(in);
        }
        return new CountryAreas(id, outer, inner);
    }

    private static Point[] readRing(ObjectInputStream in) throws IOException {
        Point[] ring = new Point[in.readInt()];
        for (int j = 0; j < ring.length; ++j) {
            ring[j] = Point.read(in);
        }
        return ring;
    }

    private static boolean isPointInPolygon(Point p, Point[] v) {
        int wn = 0;
        int j = 0;
        int i = v.length - 1;
        while (j < v.length) {
            if (v[i].y <= p.y) {
                if (v[j].y > p.y && CountryAreas.isLeft(v[i], v[j], p) > 0L) {
                    ++wn;
                }
            } else if (v[j].y <= p.y && CountryAreas.isLeft(v[i], v[j], p) < 0L) {
                --wn;
            }
            i = j++;
        }
        return wn != 0;
    }

    private static long isLeft(Point p0, Point p1, Point p) {
        return ((long)p1.x - (long)p0.x) * ((long)p.y - (long)p0.y) - ((long)p.x - (long)p0.x) * ((long)p1.y - (long)p0.y);
    }
}

