/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_legal_default_speeds.tagfilter;

import de.westnordost.osm_legal_default_speeds.tagfilter.BooleanExpression;
import de.westnordost.osm_legal_default_speeds.tagfilter.BooleanExpressionBuilder;
import de.westnordost.osm_legal_default_speeds.tagfilter.NumberWithUnitParserKt;
import de.westnordost.osm_legal_default_speeds.tagfilter.ParseException;
import de.westnordost.osm_legal_default_speeds.tagfilter.StringWithCursor;
import de.westnordost.osm_legal_default_speeds.tagfilter.TagFilterExpressionParserKt;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasKey;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasKeyLike;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTag;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagGreaterOrEqualThan;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagGreaterThan;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagLessOrEqualThan;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagLessThan;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagLike;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.HasTagValueLike;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.NotHasKey;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.NotHasKeyLike;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.NotHasTag;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.NotHasTagValueLike;
import de.westnordost.osm_legal_default_speeds.tagfilter.filters.TagFilter;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002\u001a\f\u0010 \u001a\u00020\u001e*\u00020\u001fH\u0002\u001a\f\u0010!\u001a\u00020\u001e*\u00020\u001fH\u0002\u001a\u0013\u0010\"\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010#\u001a\f\u0010$\u001a\u00020\u001e*\u00020\u001fH\u0002\u001a\u000e\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020\u001fH\u0002\u001a$\u0010&\u001a\u00020'*\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u000e\u0010*\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030+H\u0002\u001a\f\u0010,\u001a\u00020\u0001*\u00020\u001fH\u0002\u001a\u000e\u0010-\u001a\u0004\u0018\u00010\u0001*\u00020\u001fH\u0002\u001a\f\u0010.\u001a\u00020\u0001*\u00020\u001fH\u0002\u001a\f\u0010/\u001a\u00020\u0001*\u00020\u001fH\u0002\u001a\f\u00100\u001a\u000201*\u00020\u001fH\u0002\u001a$\u00102\u001a\u001a\u0012\u0004\u0012\u000201\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010403*\u00020\u001fH\u0000\u001a\f\u00105\u001a\u00020\u0001*\u00020\u001fH\u0002\u001a\f\u00106\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0011j\b\u0012\u0004\u0012\u00020\u0001`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\"\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"AND", "", "COMPARISON_OPERATORS", "", "EQUALS", "ESCAPED_QUOTE_REGEX", "Lkotlin/text/Regex;", "GREATER_OR_EQUAL_THAN", "GREATER_THAN", "KEY_VALUE_OPERATORS", "LESS_OR_EQUAL_THAN", "LESS_THAN", "LIKE", "NOT", "NOT_EQUALS", "NOT_LIKE", "OPERATORS", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "OR", "PLACEHOLDER_END", "PLACEHOLDER_START", "QUOTATION_MARKS", "", "RESERVED_WORDS", "", "[Ljava/lang/String;", "WHITESPACES_REGEX", "WHITESPACE_REGEX", "expectAnyNumberOfSpaces", "", "Lde/westnordost/osm_legal_default_speeds/tagfilter/StringWithCursor;", "findKeyLength", "findQuotableWordLength", "findQuotationLength", "(Lde/westnordost/osm_legal_default_speeds/tagfilter/StringWithCursor;)Ljava/lang/Integer;", "findWordLength", "nextIsReservedWord", "parseBracketsAndSpaces", "", "bracket", "", "expr", "Lde/westnordost/osm_legal_default_speeds/tagfilter/BooleanExpressionBuilder;", "parseKey", "parseOperatorWithSurroundingSpaces", "parsePlaceholder", "parseQuotableWord", "parseTag", "Lde/westnordost/osm_legal_default_speeds/tagfilter/filters/TagFilter;", "parseTags", "Lde/westnordost/osm_legal_default_speeds/tagfilter/BooleanExpression;", "", "parseWord", "stripAndUnescapeQuotes", "library"})
@SourceDebugExtension(value={"SMAP\nTagFilterExpressionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagFilterExpressionParser.kt\nde/westnordost/osm_legal_default_speeds/tagfilter/TagFilterExpressionParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,300:1\n288#2,2:301\n1282#3,2:303\n*S KotlinDebug\n*F\n+ 1 TagFilterExpressionParser.kt\nde/westnordost/osm_legal_default_speeds/tagfilter/TagFilterExpressionParserKt\n*L\n212#1:301,2\n252#1:303,2\n*E\n"})
public final class TagFilterExpressionParserKt {
    @NotNull
    private static final String OR = "or";
    @NotNull
    private static final String AND = "and";
    @NotNull
    private static final String EQUALS = "=";
    @NotNull
    private static final String NOT_EQUALS = "!=";
    @NotNull
    private static final String LIKE = "~";
    @NotNull
    private static final String PLACEHOLDER_START = "{";
    @NotNull
    private static final String PLACEHOLDER_END = "}";
    @NotNull
    private static final String NOT = "!";
    @NotNull
    private static final String NOT_LIKE = "!~";
    @NotNull
    private static final String GREATER_THAN = ">";
    @NotNull
    private static final String LESS_THAN = "<";
    @NotNull
    private static final String GREATER_OR_EQUAL_THAN = ">=";
    @NotNull
    private static final String LESS_OR_EQUAL_THAN = "<=";
    @NotNull
    private static final String[] RESERVED_WORDS;
    @NotNull
    private static final char[] QUOTATION_MARKS;
    @NotNull
    private static final Set<String> KEY_VALUE_OPERATORS;
    @NotNull
    private static final Set<String> COMPARISON_OPERATORS;
    @NotNull
    private static final LinkedHashSet<String> OPERATORS;
    @NotNull
    private static final Regex ESCAPED_QUOTE_REGEX;
    @NotNull
    private static final Regex WHITESPACE_REGEX;
    @NotNull
    private static final Regex WHITESPACES_REGEX;

    @NotNull
    public static final BooleanExpression<TagFilter, Map<String, String>> parseTags(@NotNull StringWithCursor $this$parseTags) {
        BooleanExpressionBuilder builder;
        block10: {
            Intrinsics.checkNotNullParameter((Object)$this$parseTags, (String)"<this>");
            builder = new BooleanExpressionBuilder();
            boolean first = true;
            while (true) {
                if (!TagFilterExpressionParserKt.parseBracketsAndSpaces($this$parseTags, '(', builder) && !first) {
                    throw new ParseException("Expected a whitespace or bracket before the tag", $this$parseTags.getCursorPos());
                }
                first = false;
                if ($this$parseTags.nextIsAndAdvance("!{")) {
                    builder.addNotPlaceholder(TagFilterExpressionParserKt.parsePlaceholder($this$parseTags));
                } else if ($this$parseTags.nextIsAndAdvance(PLACEHOLDER_START)) {
                    builder.addPlaceholder(TagFilterExpressionParserKt.parsePlaceholder($this$parseTags));
                } else {
                    builder.addValue(TagFilterExpressionParserKt.parseTag($this$parseTags));
                }
                boolean separated = TagFilterExpressionParserKt.parseBracketsAndSpaces($this$parseTags, ')', builder);
                if (StringWithCursor.isAtEnd$default($this$parseTags, 0, 1, null)) break block10;
                if (!separated) {
                    throw new ParseException("Expected a whitespace or bracket after the tag", $this$parseTags.getCursorPos());
                }
                if ($this$parseTags.nextIsAndAdvance(OR)) {
                    builder.addOr();
                    continue;
                }
                if (!$this$parseTags.nextIsAndAdvance(AND)) break;
                builder.addAnd();
            }
            throw new ParseException("Expected end of string, 'and' or 'or'", $this$parseTags.getCursorPos());
        }
        try {
            BooleanExpression<TagFilter, Map<String, String>> booleanExpression = builder.build();
            Intrinsics.checkNotNull(booleanExpression);
            return booleanExpression;
        }
        catch (IllegalStateException e) {
            throw new ParseException(e.getMessage(), $this$parseTags.getCursorPos());
        }
    }

    private static final boolean parseBracketsAndSpaces(StringWithCursor $this$parseBracketsAndSpaces, char bracket, BooleanExpressionBuilder<?, ?> expr) {
        int loopStartCursorPos;
        int initialCursorPos = $this$parseBracketsAndSpaces.getCursorPos();
        do {
            loopStartCursorPos = $this$parseBracketsAndSpaces.getCursorPos();
            TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseBracketsAndSpaces);
            if (!$this$parseBracketsAndSpaces.nextIsAndAdvance(bracket)) continue;
            try {
                if (bracket == '(') {
                    expr.addOpenBracket();
                    continue;
                }
                if (bracket != ')') continue;
                expr.addCloseBracket();
            }
            catch (IllegalStateException e) {
                throw new ParseException(e.getMessage(), $this$parseBracketsAndSpaces.getCursorPos());
            }
        } while (loopStartCursorPos < $this$parseBracketsAndSpaces.getCursorPos());
        TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseBracketsAndSpaces);
        return initialCursorPos < $this$parseBracketsAndSpaces.getCursorPos();
    }

    private static final TagFilter parseTag(StringWithCursor $this$parseTag) {
        String operator;
        block41: {
            String key;
            block39: {
                if ($this$parseTag.nextIsAndAdvance(NOT)) {
                    if ($this$parseTag.nextIsAndAdvance(LIKE)) {
                        TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseTag);
                        return new NotHasKeyLike(TagFilterExpressionParserKt.parseKey($this$parseTag));
                    }
                    TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseTag);
                    return new NotHasKey(TagFilterExpressionParserKt.parseKey($this$parseTag));
                }
                if ($this$parseTag.nextIsAndAdvance(LIKE)) {
                    TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseTag);
                    String key2 = TagFilterExpressionParserKt.parseKey($this$parseTag);
                    String operator2 = TagFilterExpressionParserKt.parseOperatorWithSurroundingSpaces($this$parseTag);
                    if (operator2 == null) {
                        return new HasKeyLike(key2);
                    }
                    if (Intrinsics.areEqual((Object)LIKE, (Object)operator2)) {
                        return new HasTagLike(key2, TagFilterExpressionParserKt.parseQuotableWord($this$parseTag));
                    }
                    throw new ParseException("Unexpected operator '" + operator2 + "': The key prefix operator '~' must be used together with the binary operator '~'", $this$parseTag.getCursorPos());
                }
                key = TagFilterExpressionParserKt.parseKey($this$parseTag);
                String string = TagFilterExpressionParserKt.parseOperatorWithSurroundingSpaces($this$parseTag);
                if (string == null) {
                    return new HasKey(key);
                }
                operator = string;
                if (!KEY_VALUE_OPERATORS.contains(operator)) break block39;
                String value = TagFilterExpressionParserKt.parseQuotableWord($this$parseTag);
                switch (operator) {
                    case "=": {
                        return new HasTag(key, value);
                    }
                    case "!=": {
                        return new NotHasTag(key, value);
                    }
                    case "~": {
                        return new HasTagValueLike(key, value);
                    }
                    case "!~": {
                        return new NotHasTagValueLike(key, value);
                    }
                }
            }
            if (!COMPARISON_OPERATORS.contains(operator)) break block41;
            Double d = NumberWithUnitParserKt.withOptionalUnitToDoubleOrNull(TagFilterExpressionParserKt.parseWord($this$parseTag));
            if (d == null) {
                throw new ParseException("Expected a number (e.g. 3.5) or a number with a known unit (e.g. 3.5st)", $this$parseTag.getCursorPos());
            }
            float value = (float)d.doubleValue();
            switch (operator) {
                case ">": {
                    return new HasTagGreaterThan(key, value);
                }
                case ">=": {
                    return new HasTagGreaterOrEqualThan(key, value);
                }
                case "<": {
                    return new HasTagLessThan(key, value);
                }
                case "<=": {
                    return new HasTagLessOrEqualThan(key, value);
                }
            }
            throw new ParseException("Expected a number (e.g. 3.5) or a number with a known unit (e.g. 3.5st)", $this$parseTag.getCursorPos());
        }
        throw new ParseException("Unknown operator '" + operator + '\'', $this$parseTag.getCursorPos());
    }

    private static final String parseKey(StringWithCursor $this$parseKey) {
        String reserved = TagFilterExpressionParserKt.nextIsReservedWord($this$parseKey);
        if (reserved != null) {
            throw new ParseException("A key cannot be named like the reserved word '" + reserved + "', surround it with quotation marks", $this$parseKey.getCursorPos());
        }
        int length = TagFilterExpressionParserKt.findKeyLength($this$parseKey);
        if (length == 0) {
            throw new ParseException("Missing key (dangling prefix operator)", $this$parseKey.getCursorPos());
        }
        return TagFilterExpressionParserKt.stripAndUnescapeQuotes($this$parseKey.advanceBy(length));
    }

    private static final String parseOperatorWithSurroundingSpaces(StringWithCursor $this$parseOperatorWithSurroundingSpaces) {
        Object v0;
        int spaces;
        block2: {
            spaces = TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseOperatorWithSurroundingSpaces);
            Iterable $this$firstOrNull$iv = OPERATORS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!$this$parseOperatorWithSurroundingSpaces.nextIsAndAdvance(it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String result = v0;
        if (result == null) {
            $this$parseOperatorWithSurroundingSpaces.retreatBy(spaces);
            return null;
        }
        TagFilterExpressionParserKt.expectAnyNumberOfSpaces($this$parseOperatorWithSurroundingSpaces);
        return result;
    }

    private static final String parsePlaceholder(StringWithCursor $this$parsePlaceholder) {
        int length = StringWithCursor.findNext$default($this$parsePlaceholder, PLACEHOLDER_END, 0, 2, null);
        if ($this$parsePlaceholder.isAtEnd(length)) {
            throw new ParseException("Missing closing bracket '}' for placeholder", $this$parsePlaceholder.getCursorPos() + length);
        }
        String result = $this$parsePlaceholder.advanceBy(length);
        $this$parsePlaceholder.advance();
        return result;
    }

    private static final String parseQuotableWord(StringWithCursor $this$parseQuotableWord) {
        int length = TagFilterExpressionParserKt.findQuotableWordLength($this$parseQuotableWord);
        if (length == 0) {
            throw new ParseException("Missing value (dangling operator)", $this$parseQuotableWord.getCursorPos());
        }
        return TagFilterExpressionParserKt.stripAndUnescapeQuotes($this$parseQuotableWord.advanceBy(length));
    }

    private static final String parseWord(StringWithCursor $this$parseWord) {
        int length = TagFilterExpressionParserKt.findWordLength($this$parseWord);
        if (length == 0) {
            throw new ParseException("Missing value (dangling operator)", $this$parseWord.getCursorPos());
        }
        return $this$parseWord.advanceBy(length);
    }

    private static final int expectAnyNumberOfSpaces(StringWithCursor $this$expectAnyNumberOfSpaces) {
        Object object = $this$expectAnyNumberOfSpaces.nextMatchesAndAdvance(WHITESPACES_REGEX);
        return object != null && (object = object.getValue()) != null ? ((String)object).length() : 0;
    }

    private static final String nextIsReservedWord(StringWithCursor $this$nextIsReservedWord) {
        String string;
        block1: {
            int wordLength = TagFilterExpressionParserKt.findWordLength($this$nextIsReservedWord);
            String[] $this$firstOrNull$iv = RESERVED_WORDS;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!($this$nextIsReservedWord.nextIs(it) && wordLength == it.length())) continue;
                string = element$iv;
                break block1;
            }
            string = null;
        }
        return string;
    }

    private static final int findKeyLength(StringWithCursor $this$findKeyLength) {
        Integer length;
        Integer n = length = TagFilterExpressionParserKt.findQuotationLength($this$findKeyLength);
        if (n != null) {
            return n;
        }
        length = TagFilterExpressionParserKt.findWordLength($this$findKeyLength);
        for (String o : OPERATORS) {
            Intrinsics.checkNotNullExpressionValue((Object)o, (String)"o");
            int opLen = StringWithCursor.findNext$default($this$findKeyLength, o, 0, 2, null);
            if (opLen >= length) continue;
            length = opLen;
        }
        return length;
    }

    private static final int findWordLength(StringWithCursor $this$findWordLength) {
        return Math.min(StringWithCursor.findNext$default($this$findWordLength, WHITESPACE_REGEX, 0, 2, null), StringWithCursor.findNext$default($this$findWordLength, ')', 0, 2, null));
    }

    private static final int findQuotableWordLength(StringWithCursor $this$findQuotableWordLength) {
        Integer n = TagFilterExpressionParserKt.findQuotationLength($this$findQuotableWordLength);
        return n != null ? n : TagFilterExpressionParserKt.findWordLength($this$findQuotableWordLength);
    }

    private static final Integer findQuotationLength(StringWithCursor $this$findQuotationLength) {
        for (char quot : QUOTATION_MARKS) {
            char c;
            Character c2;
            if (!$this$findQuotationLength.nextIs(quot)) continue;
            int length = 0;
            do {
                if ($this$findQuotationLength.isAtEnd(length = $this$findQuotationLength.findNext(quot, 1 + length))) {
                    throw new ParseException("Did not close quotation marks", $this$findQuotationLength.getCursorPos() - 1);
                }
                c2 = $this$findQuotationLength.get($this$findQuotationLength.getCursorPos() + length - 1);
                c = '\\';
            } while (c2 != null && c2.charValue() == c);
            return length + 1;
        }
        return null;
    }

    private static final String stripAndUnescapeQuotes(String $this$stripAndUnescapeQuotes) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)$this$stripAndUnescapeQuotes, (char)'\'', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)$this$stripAndUnescapeQuotes, (char)'\"', (boolean)false, (int)2, null)) {
            String string2 = $this$stripAndUnescapeQuotes.substring(1, $this$stripAndUnescapeQuotes.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = $this$stripAndUnescapeQuotes;
        }
        String trimmed = string;
        CharSequence charSequence = trimmed;
        Regex regex = ESCAPED_QUOTE_REGEX;
        Function1 function1 = stripAndUnescapeQuotes.unescaped.1.INSTANCE;
        String unescaped2 = regex.replace(charSequence, function1);
        return unescaped2;
    }

    static {
        Object[] objectArray = new String[]{OR, AND};
        RESERVED_WORDS = objectArray;
        objectArray = new char[2];
        objectArray[0] = (String)34;
        objectArray[1] = (String)39;
        QUOTATION_MARKS = (char[])objectArray;
        objectArray = new String[]{EQUALS, NOT_EQUALS, LIKE, NOT_LIKE};
        KEY_VALUE_OPERATORS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{GREATER_THAN, GREATER_OR_EQUAL_THAN, LESS_THAN, LESS_OR_EQUAL_THAN};
        COMPARISON_OPERATORS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{GREATER_OR_EQUAL_THAN, LESS_OR_EQUAL_THAN, GREATER_THAN, LESS_THAN, NOT_EQUALS, EQUALS, NOT_LIKE, LIKE};
        OPERATORS = SetsKt.linkedSetOf((Object[])objectArray);
        ESCAPED_QUOTE_REGEX = new Regex("\\\\(['\"])");
        WHITESPACE_REGEX = new Regex("\\s");
        WHITESPACES_REGEX = new Regex("\\s*");
    }
}

