/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.errors.OsmApiException;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.MapDataParser;
import de.westnordost.osmapi.map.OsmMapDataFactory;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.Way;
import de.westnordost.osmapi.map.handler.SingleOsmElementHandler;
import de.westnordost.osmapi.map.handler.WrapperOsmElementHandler;

public class MapDataHistoryApi {
    private static final String NODE = "node";
    private static final String WAY = "way";
    private static final String RELATION = "relation";
    private static final String HISTORY = "history";
    private final OsmConnection osm;
    private final MapDataFactory factory;

    public MapDataHistoryApi(OsmConnection osm, MapDataFactory factory) {
        this.osm = osm;
        this.factory = factory;
    }

    public MapDataHistoryApi(OsmConnection osm) {
        this(osm, new OsmMapDataFactory());
    }

    public void getNodeHistory(long id, Handler<Node> handler) {
        WrapperOsmElementHandler<Node> mapDataHandler = new WrapperOsmElementHandler<Node>(Node.class, handler);
        boolean authenticate = this.osm.getOAuth() != null;
        this.osm.makeRequest("node/" + id + "/" + HISTORY, authenticate, (ApiResponseReader)new MapDataParser(mapDataHandler, this.factory));
    }

    public void getWayHistory(long id, Handler<Way> handler) {
        WrapperOsmElementHandler<Way> mapDataHandler = new WrapperOsmElementHandler<Way>(Way.class, handler);
        boolean authenticate = this.osm.getOAuth() != null;
        this.osm.makeRequest("way/" + id + "/" + HISTORY, authenticate, (ApiResponseReader)new MapDataParser(mapDataHandler, this.factory));
    }

    public void getRelationHistory(long id, Handler<Relation> handler) {
        WrapperOsmElementHandler<Relation> mapDataHandler = new WrapperOsmElementHandler<Relation>(Relation.class, handler);
        boolean authenticate = this.osm.getOAuth() != null;
        this.osm.makeRequest("relation/" + id + "/" + HISTORY, authenticate, (ApiResponseReader)new MapDataParser(mapDataHandler, this.factory));
    }

    public Node getNodeVersion(long id, int version) {
        return this.getElementVersion("node/" + id + "/" + version, Node.class);
    }

    public Way getWayVersion(long id, int version) {
        return this.getElementVersion("way/" + id + "/" + version, Way.class);
    }

    public Relation getRelationVersion(long id, int version) {
        return this.getElementVersion("relation/" + id + "/" + version, Relation.class);
    }

    private <T extends Element> T getElementVersion(String call, Class<T> tClass) {
        SingleOsmElementHandler<T> handler = new SingleOsmElementHandler<T>(tClass);
        try {
            boolean authenticate = this.osm.getOAuth() != null;
            this.osm.makeRequest(call, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
        }
        catch (OsmApiException e) {
            switch (e.getErrorCode()) {
                case 403: 
                case 404: 
                case 410: {
                    return null;
                }
            }
            throw e;
        }
        return (T)((Element)handler.get());
    }
}

