/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.changes;

import de.westnordost.osmapi.map.changes.MapDataChanges;
import de.westnordost.osmapi.map.changes.MapDataChangesHandler;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.Way;
import java.util.ArrayList;
import java.util.List;

public class SimpleMapDataChangesHandler
implements MapDataChangesHandler,
MapDataChanges {
    private final List<Element> creations = new ArrayList<Element>();
    private final List<Element> modifications = new ArrayList<Element>();
    private final List<Element> deletions = new ArrayList<Element>();
    private Mode mode;

    @Override
    public void onStartCreations() {
        this.mode = Mode.CREATIONS;
    }

    @Override
    public void onStartModifications() {
        this.mode = Mode.MODIFICATIONS;
    }

    @Override
    public void onStartDeletions() {
        this.mode = Mode.DELETIONS;
    }

    @Override
    public void handle(BoundingBox bounds) {
    }

    @Override
    public void handle(Node node) {
        this.handleElement(node);
    }

    @Override
    public void handle(Way way) {
        this.handleElement(way);
    }

    @Override
    public void handle(Relation relation) {
        this.handleElement(relation);
    }

    private void handleElement(Element element) {
        switch (this.mode) {
            case CREATIONS: {
                this.creations.add(element);
                break;
            }
            case MODIFICATIONS: {
                this.modifications.add(element);
                break;
            }
            case DELETIONS: {
                this.deletions.add(element);
            }
        }
    }

    @Override
    public List<Element> getDeletions() {
        return this.deletions;
    }

    @Override
    public List<Element> getModifications() {
        return this.modifications;
    }

    @Override
    public List<Element> getCreations() {
        return this.creations;
    }

    @Override
    public List<Element> getAll() {
        ArrayList<Element> result = new ArrayList<Element>();
        result.addAll(this.creations);
        result.addAll(this.modifications);
        result.addAll(this.deletions);
        return result;
    }

    private static enum Mode {
        CREATIONS,
        MODIFICATIONS,
        DELETIONS;

    }
}

