/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ModificationAwareList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> list;
    private boolean modified;

    public ModificationAwareList(List<T> list) {
        this.list = list;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void onModification() {
        this.modified = true;
    }

    @Override
    public void add(int location, T object) {
        this.list.add(location, object);
        this.onModification();
    }

    @Override
    public boolean add(T object) {
        boolean result = this.list.add(object);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public boolean addAll(int location, Collection<? extends T> collection) {
        boolean result = this.list.addAll(location, collection);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean result = this.list.addAll(collection);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.onModification();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public T get(int location) {
        return this.list.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorWrapper(this.list.iterator());
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListIteratorWrapper(this.list.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int location) {
        return new ListIteratorWrapper(this.list.listIterator(location));
    }

    @Override
    public T remove(int location) {
        T result = this.list.remove(location);
        this.onModification();
        return result;
    }

    @Override
    public boolean remove(Object object) {
        boolean result = this.list.remove(object);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = this.list.removeAll(collection);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean result = this.list.retainAll(collection);
        if (result) {
            this.onModification();
        }
        return result;
    }

    @Override
    public T set(int location, T object) {
        T result = this.list.set(location, object);
        if (result != object) {
            this.onModification();
        }
        return result;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int start, int end) {
        return new ModificationAwareSubList(this.list.subList(start, end), this);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <U> U[] toArray(U[] array) {
        return this.list.toArray(array);
    }

    @Override
    public boolean equals(Object other) {
        return this.list.equals(other);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    private class ListIteratorWrapper
    implements ListIterator<T> {
        private ListIterator<T> it;

        public ListIteratorWrapper(ListIterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        @Override
        public T previous() {
            return this.it.previous();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void add(T object) {
            this.it.add(object);
            ModificationAwareList.this.onModification();
        }

        @Override
        public void remove() {
            this.it.remove();
            ModificationAwareList.this.onModification();
        }

        @Override
        public void set(T object) {
            this.it.set(object);
            ModificationAwareList.this.onModification();
        }
    }

    private class IteratorWrapper
    implements Iterator<T> {
        private Iterator<T> it;

        public IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
            ModificationAwareList.this.onModification();
        }
    }

    private class ModificationAwareSubList
    extends ModificationAwareList<T> {
        private static final long serialVersionUID = 1L;
        ModificationAwareList<T> master;

        public ModificationAwareSubList(List<T> list, ModificationAwareList<T> master) {
            super(list);
            this.master = master;
        }

        @Override
        protected void onModification() {
            this.master.onModification();
        }

        @Override
        public List<T> subList(int start, int end) {
            return new ModificationAwareSubList(ModificationAwareList.this.list.subList(start, end), this.master);
        }
    }
}

