/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.changesets.Changeset;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.OsmTags;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public abstract class OsmElement
implements Element,
Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private int version;
    private Changeset changeset;
    private Instant editedAt;
    private OsmTags tags;
    private boolean deleted;
    private boolean created;
    private boolean modified;

    public OsmElement(long id, int version, Map<String, String> tags) {
        this(id, version, tags, null, null);
    }

    public OsmElement(long id, int version, Map<String, String> tags, Changeset changeset, Instant editedAt) {
        this.id = id;
        this.version = version;
        this.changeset = changeset;
        this.tags = tags != null ? new OsmTags(tags) : new OsmTags((Map<String, String>)new HashMap<String, String>(0));
        this.editedAt = editedAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Changeset getChangeset() {
        return this.changeset;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.modified = true;
        this.tags = tags != null ? new OsmTags(tags) : null;
    }

    @Override
    public boolean isNew() {
        return this.id < 0L || this.created;
    }

    public void setNew(boolean isNew) {
        this.created = isNew;
    }

    @Override
    public boolean isModified() {
        return this.modified || this.tags != null && this.tags.isModified();
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public abstract Element.Type getType();

    @Override
    public Instant getEditedAt() {
        return this.editedAt;
    }
}

