/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.map.data.ModificationAwareMap;
import java.io.Serializable;
import java.util.Map;

public class OsmTags
extends ModificationAwareMap<String, String>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public OsmTags(Map<String, String> map) {
        super(map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            OsmTags.checkKeyValueLength(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String put(String key, String value) {
        OsmTags.checkKeyValueLength(key, value);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            OsmTags.checkKeyValueLength(entry.getKey(), entry.getValue());
        }
        super.putAll(map);
    }

    private static void checkKeyValueLength(String key, String value) {
        if (key.length() >= 256) {
            throw new IllegalArgumentException("For key \"" + key + "\": Key length is limitedto less than 256 characters.");
        }
        if (value.length() >= 256) {
            throw new IllegalArgumentException("For value \"" + value + "\": Value length is limited to less than 256 characters.");
        }
    }
}

