/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.handler;

import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.Way;
import de.westnordost.osmapi.map.handler.MapDataHandler;

public abstract class OneElementTypeHandler<T>
implements MapDataHandler {
    private final Class<T> tClass;

    public OneElementTypeHandler(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public void handle(BoundingBox bounds) {
        if (this.tClass.isAssignableFrom(bounds.getClass())) {
            this.handleElement(bounds);
        }
    }

    @Override
    public void handle(Node node) {
        if (this.tClass.isAssignableFrom(node.getClass())) {
            this.handleElement(node);
        }
    }

    @Override
    public void handle(Way way) {
        if (this.tClass.isAssignableFrom(way.getClass())) {
            this.handleElement(way);
        }
    }

    @Override
    public void handle(Relation relation) {
        if (this.tClass.isAssignableFrom(relation.getClass())) {
            this.handleElement(relation);
        }
    }

    protected abstract void handleElement(T var1);
}

