/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map;

import de.westnordost.osmapi.ApiRequestWriter;
import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.OsmConnection;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.IdResponseReader;
import de.westnordost.osmapi.common.XmlWriter;
import de.westnordost.osmapi.common.errors.OsmApiException;
import de.westnordost.osmapi.common.errors.OsmBadUserInputException;
import de.westnordost.osmapi.common.errors.OsmNotFoundException;
import de.westnordost.osmapi.common.errors.OsmQueryTooBigException;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.MapDataParser;
import de.westnordost.osmapi.map.OsmMapDataFactory;
import de.westnordost.osmapi.map.changes.DiffElement;
import de.westnordost.osmapi.map.changes.MapDataChangesWriter;
import de.westnordost.osmapi.map.changes.MapDataDiffParser;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.Way;
import de.westnordost.osmapi.map.handler.ListOsmElementHandler;
import de.westnordost.osmapi.map.handler.MapDataHandler;
import de.westnordost.osmapi.map.handler.SingleOsmElementHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapDataApi {
    private static final String NODE = "node";
    private static final String WAY = "way";
    private static final String RELATION = "relation";
    private static final String FULL = "full";
    private final OsmConnection osm;
    private final MapDataFactory factory;

    public MapDataApi(OsmConnection osm, MapDataFactory factory) {
        this.osm = osm;
        this.factory = factory;
    }

    public MapDataApi(OsmConnection osm) {
        this(osm, new OsmMapDataFactory());
    }

    public long updateMap(String comment, String source, Iterable<Element> elements, Handler<DiffElement> handler) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("comment", comment);
        tags.put("source", source);
        return this.updateMap(tags, elements, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateMap(Map<String, String> tags, Iterable<Element> elements, Handler<DiffElement> handler) {
        tags.put("created_by", this.osm.getUserAgent());
        long changesetId = this.openChangeset(tags);
        try {
            this.uploadChanges(changesetId, elements, handler);
        }
        finally {
            this.closeChangeset(changesetId);
        }
        return changesetId;
    }

    public void uploadChanges(long changesetId, Iterable<Element> elements, Handler<DiffElement> handler) {
        MapDataDiffParser parser = null;
        if (handler != null) {
            parser = new MapDataDiffParser(handler);
        }
        this.osm.makeAuthenticatedRequest("changeset/" + changesetId + "/upload", "POST", (ApiRequestWriter)new MapDataChangesWriter(changesetId, elements), (ApiResponseReader)parser);
    }

    public long openChangeset(Map<String, String> tags) {
        return (Long)this.osm.makeAuthenticatedRequest("changeset/create", "PUT", (ApiRequestWriter)this.createOsmChangesetTagsWriter(tags), (ApiResponseReader)new IdResponseReader());
    }

    public void updateChangeset(long changesetId, Map<String, String> tags) {
        this.osm.makeAuthenticatedRequest("changeset/" + changesetId, "PUT", (ApiRequestWriter)this.createOsmChangesetTagsWriter(tags), null);
    }

    private XmlWriter createOsmChangesetTagsWriter(final Map<String, String> tags) {
        return new XmlWriter(){

            protected void write() throws IOException {
                this.begin("osm");
                this.begin("changeset");
                for (Map.Entry tag : tags.entrySet()) {
                    this.begin("tag");
                    this.attribute("k", (String)tag.getKey());
                    this.attribute("v", (String)tag.getValue());
                    this.end();
                }
                this.end();
                this.end();
            }
        };
    }

    public void closeChangeset(long changesetId) {
        this.osm.makeAuthenticatedRequest("changeset/" + changesetId + "/close", "PUT");
    }

    public void getMap(BoundingBox bounds, MapDataHandler handler) {
        if (bounds.crosses180thMeridian()) {
            throw new IllegalArgumentException("bounds may not cross the 180th meridian");
        }
        String request = "map?bbox=" + bounds.getAsLeftBottomRightTopString();
        boolean authenticate = this.osm.getOAuthAccessToken() != null;
        try {
            this.osm.makeRequest(request, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
        }
        catch (OsmBadUserInputException e) {
            throw new OsmQueryTooBigException((OsmApiException)e);
        }
    }

    public void getWayComplete(long id, MapDataHandler handler) {
        boolean authenticate = this.osm.getOAuthAccessToken() != null;
        this.osm.makeRequest("way/" + id + "/" + FULL, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
    }

    public void getRelationComplete(long id, MapDataHandler handler) {
        boolean authenticate = this.osm.getOAuthAccessToken() != null;
        this.osm.makeRequest("relation/" + id + "/" + FULL, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
    }

    public Node getNode(long id) {
        return this.getOneElement("node/" + id, Node.class);
    }

    public Way getWay(long id) {
        return this.getOneElement("way/" + id, Way.class);
    }

    public Relation getRelation(long id) {
        return this.getOneElement("relation/" + id, Relation.class);
    }

    private <T extends Element> T getOneElement(String call, Class<T> tClass) {
        SingleOsmElementHandler<T> handler = new SingleOsmElementHandler<T>(tClass);
        try {
            boolean authenticate = this.osm.getOAuthAccessToken() != null;
            this.osm.makeRequest(call, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
        }
        catch (OsmNotFoundException e) {
            return null;
        }
        return (T)((Element)handler.get());
    }

    public List<Node> getNodes(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getSomeElements("nodes?nodes=" + MapDataApi.toCommaList(nodeIds), Node.class);
    }

    public List<Way> getWays(Collection<Long> wayIds) {
        if (wayIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getSomeElements("ways?ways=" + MapDataApi.toCommaList(wayIds), Way.class);
    }

    public List<Relation> getRelations(Collection<Long> relationIds) {
        if (relationIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getSomeElements("relations?relations=" + MapDataApi.toCommaList(relationIds), Relation.class);
    }

    public List<Way> getWaysForNode(long id) {
        return this.getSomeElements("node/" + id + "/" + WAY + "s", Way.class);
    }

    public List<Relation> getRelationsForNode(long id) {
        return this.getSomeElements("node/" + id + "/" + RELATION + "s", Relation.class);
    }

    public List<Relation> getRelationsForWay(long id) {
        return this.getSomeElements("way/" + id + "/" + RELATION + "s", Relation.class);
    }

    public List<Relation> getRelationsForRelation(long id) {
        return this.getSomeElements("relation/" + id + "/" + RELATION + "s", Relation.class);
    }

    private static String toCommaList(Iterable<Long> vals) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Long id : vals) {
            if (id == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(id);
        }
        return result.toString();
    }

    private <T extends Element> List<T> getSomeElements(String call, Class<T> tClass) {
        ListOsmElementHandler<T> handler = new ListOsmElementHandler<T>(tClass);
        boolean authenticate = this.osm.getOAuthAccessToken() != null;
        this.osm.makeRequest(call, authenticate, (ApiResponseReader)new MapDataParser(handler, this.factory));
        return handler.get();
    }
}

