/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.changesets.Changeset;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.MapDataFactory;
import de.westnordost.osmapi.map.data.BoundingBox;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.RelationMember;
import de.westnordost.osmapi.map.handler.MapDataHandler;
import de.westnordost.osmapi.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MapDataParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String NODE = "node";
    private static final String WAY = "way";
    private static final String RELATION = "relation";
    private final MapDataHandler handler;
    private final MapDataFactory factory;
    private Map<Long, User> users;
    private Map<Long, Changeset> changesets;
    private long id = -1L;
    private int version = 0;
    private Long changesetId;
    private Instant timestamp;
    private Double lat;
    private Double lon;
    private Map<String, String> tags;
    private List<RelationMember> members = new ArrayList<RelationMember>();
    private List<Long> nodes = new LinkedList<Long>();

    public MapDataParser(MapDataHandler handler, MapDataFactory factory) {
        this.handler = handler;
        this.factory = factory;
    }

    public Void parse(InputStream in) throws IOException {
        this.users = new HashMap<Long, User>();
        this.changesets = new HashMap<Long, Changeset>();
        this.doParse(in);
        this.users = null;
        this.changesets = null;
        return null;
    }

    protected void onStartElement() throws ParseException {
        String name = this.getName();
        if (name.equals("tag")) {
            if (this.tags == null) {
                this.tags = new HashMap<String, String>();
            }
            this.tags.put(this.getAttribute("k"), this.getAttribute("v"));
        } else if (name.equals("nd")) {
            this.nodes.add(this.getLongAttribute("ref"));
        } else if (name.equals("member")) {
            this.members.add(this.factory.createRelationMember(this.getLongAttribute("ref"), this.getAttribute("role"), Element.Type.valueOf(this.getAttribute("type").toUpperCase(Locale.UK))));
        } else if (name.equals("bounds")) {
            BoundingBox bounds = new BoundingBox(this.getDoubleAttribute("minlat").doubleValue(), this.getDoubleAttribute("minlon").doubleValue(), this.getDoubleAttribute("maxlat").doubleValue(), this.getDoubleAttribute("maxlon").doubleValue());
            this.handler.handle(bounds);
        } else if (name.equals(NODE) || name.equals(WAY) || name.equals(RELATION)) {
            this.timestamp = this.parseTimestamp();
            this.changesetId = this.getLongAttribute("changeset");
            if (this.changesetId != null && !this.changesets.containsKey(this.changesetId)) {
                Changeset changeset = new Changeset();
                changeset.id = this.changesetId;
                changeset.user = this.parseUser();
                this.changesets.put(this.changesetId, changeset);
            }
            this.id = this.getLongAttribute("id");
            Integer v = this.getIntAttribute("version");
            int n = this.version = v != null ? v : -1;
            if (name.equals(NODE)) {
                this.lat = this.getDoubleAttribute("lat");
                this.lon = this.getDoubleAttribute("lon");
            }
        }
    }

    private Instant parseTimestamp() {
        String timestamp = this.getAttribute("timestamp");
        if (timestamp == null) {
            return null;
        }
        return Instant.parse(timestamp);
    }

    private User parseUser() {
        Long userId = this.getLongAttribute("uid");
        if (userId == null) {
            return null;
        }
        if (!this.users.containsKey(userId)) {
            User user = new User(userId.longValue(), this.getAttribute("user"));
            this.users.put(userId, user);
            return user;
        }
        return this.users.get(userId);
    }

    protected void onEndElement() {
        String name = this.getName();
        if (name.equals(NODE)) {
            this.handler.handle(this.factory.createNode(this.id, this.version, this.lat, this.lon, this.tags, this.changesets.get(this.changesetId), this.timestamp));
        } else if (name.equals(WAY)) {
            this.handler.handle(this.factory.createWay(this.id, this.version, this.nodes, this.tags, this.changesets.get(this.changesetId), this.timestamp));
            this.nodes = new LinkedList<Long>();
        } else if (name.equals(RELATION)) {
            this.handler.handle(this.factory.createRelation(this.id, this.version, this.members, this.tags, this.changesets.get(this.changesetId), this.timestamp));
            this.members = new ArrayList<RelationMember>();
        }
        if (name.equals(NODE) || name.equals(WAY) || name.equals(RELATION)) {
            this.tags = null;
        }
    }
}

