/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.changes;

import de.westnordost.osmapi.common.XmlWriter;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.RelationMember;
import de.westnordost.osmapi.map.data.Way;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MapDataChangesWriter
extends XmlWriter {
    private final long changesetId;
    private final List<Element> creations;
    private final List<Element> modifications;
    private final List<Element> deletions;

    public MapDataChangesWriter(long changesetId, Iterable<Element> elements) {
        this.changesetId = changesetId;
        this.creations = new ArrayList<Element>();
        this.modifications = new ArrayList<Element>();
        this.deletions = new ArrayList<Element>();
        for (Element element : elements) {
            if (element.isNew() && element.isDeleted()) continue;
            if (element.isNew()) {
                this.creations.add(element);
                continue;
            }
            if (element.isDeleted()) {
                this.deletions.add(element);
                continue;
            }
            if (!element.isModified()) continue;
            this.modifications.add(element);
        }
        Collections.sort(this.creations, new OrderByNodeWayRelation());
        Collections.sort(this.modifications, new OrderByRelationWayNode());
        Collections.sort(this.deletions, new OrderByRelationWayNode());
    }

    public boolean hasChanges() {
        return !this.creations.isEmpty() || !this.modifications.isEmpty() || !this.deletions.isEmpty();
    }

    private static int getTypeOrder(Element.Type type) {
        switch (type) {
            case NODE: {
                return 1;
            }
            case WAY: {
                return 2;
            }
            case RELATION: {
                return 3;
            }
        }
        return 0;
    }

    protected void write() throws IOException {
        this.begin("osmChange");
        if (!this.creations.isEmpty()) {
            this.begin("create");
            for (Element element : this.creations) {
                this.writeElement(element);
            }
            this.end();
        }
        if (!this.modifications.isEmpty()) {
            this.begin("modify");
            for (Element element : this.modifications) {
                this.writeElement(element);
            }
            this.end();
        }
        if (!this.deletions.isEmpty()) {
            this.begin("delete");
            for (Element element : this.deletions) {
                this.writeElement(element);
            }
            this.end();
        }
        this.end();
    }

    private void writeElement(Element element) throws IOException {
        this.begin(MapDataChangesWriter.toXmlName(element.getType()));
        this.writeElementAttributes(element);
        if (element instanceof Node) {
            this.writeNodeContents((Node)element);
        } else if (element instanceof Way) {
            this.writeWayContents((Way)element);
        } else if (element instanceof Relation) {
            this.writeRelationContents((Relation)element);
        }
        this.writeTags(element.getTags());
        this.end();
    }

    private static String toXmlName(Element.Type type) {
        return type.toString().toLowerCase(Locale.UK);
    }

    private void writeElementAttributes(Element element) throws IOException {
        this.attribute("id", element.getId());
        this.attribute("version", element.getVersion());
        this.attribute("changeset", this.changesetId);
    }

    private void writeNodeContents(Node node) throws IOException {
        LatLon position = node.getPosition();
        this.attribute("lat", position.getLatitude());
        this.attribute("lon", position.getLongitude());
    }

    private void writeWayContents(Way way) throws IOException {
        for (Long node : way.getNodeIds()) {
            this.begin("nd");
            this.attribute("ref", node);
            this.end();
        }
    }

    private void writeRelationContents(Relation relation) throws IOException {
        for (RelationMember member : relation.getMembers()) {
            this.begin("member");
            this.attribute("ref", member.getRef());
            this.attribute("type", MapDataChangesWriter.toXmlName(member.getType()));
            this.attribute("role", member.getRole());
            this.end();
        }
    }

    private void writeTags(Map<String, String> tags) throws IOException {
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                this.begin("tag");
                this.attribute("k", tag.getKey());
                this.attribute("v", tag.getValue());
                this.end();
            }
        }
    }

    private class OrderByNodeWayRelation
    implements Comparator<Element> {
        private OrderByNodeWayRelation() {
        }

        @Override
        public int compare(Element lhs, Element rhs) {
            return MapDataChangesWriter.getTypeOrder(lhs.getType()) - MapDataChangesWriter.getTypeOrder(rhs.getType());
        }
    }

    private class OrderByRelationWayNode
    implements Comparator<Element> {
        private OrderByRelationWayNode() {
        }

        @Override
        public int compare(Element lhs, Element rhs) {
            return MapDataChangesWriter.getTypeOrder(rhs.getType()) - MapDataChangesWriter.getTypeOrder(lhs.getType());
        }
    }
}

