/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.changes;

import de.westnordost.osmapi.ApiResponseReader;
import de.westnordost.osmapi.common.Handler;
import de.westnordost.osmapi.common.XmlParser;
import de.westnordost.osmapi.map.changes.DiffElement;
import de.westnordost.osmapi.map.data.Element;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class MapDataDiffParser
extends XmlParser
implements ApiResponseReader<Void> {
    private static final String NODE = "node";
    private static final String WAY = "way";
    private static final String RELATION = "relation";
    private final Handler<DiffElement> handler;

    public MapDataDiffParser(Handler<DiffElement> handler) {
        this.handler = handler;
    }

    public Void parse(InputStream in) throws IOException {
        this.doParse(in);
        return null;
    }

    protected void onStartElement() {
        String name = this.getName();
        if (name.equals(NODE) || name.equals(WAY) || name.equals(RELATION)) {
            DiffElement e = new DiffElement();
            e.type = Element.Type.valueOf(name.toUpperCase(Locale.UK));
            e.clientId = this.getLongAttribute("old_id");
            e.serverId = this.getLongAttribute("new_id");
            e.serverVersion = this.getIntAttribute("new_version");
            this.handler.handle((Object)e);
        }
    }

    protected void onEndElement() {
    }
}

