/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ModificationAwareMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;
    private boolean modified;

    public ModificationAwareMap(Map<K, V> map) {
        this.map = map;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void onModification() {
        this.modified = true;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.onModification();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetWrapper<Map.Entry<K, V>>(this.map.entrySet());
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new SetWrapper<K>(this.map.keySet());
    }

    @Override
    public V put(K key, V value) {
        V result = this.map.put(key, value);
        if (result != value) {
            this.onModification();
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
        if (!map.isEmpty()) {
            this.onModification();
        }
    }

    @Override
    public V remove(Object key) {
        V result = this.map.remove(key);
        if (result != null) {
            this.onModification();
        }
        return result;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean equals(Object other) {
        return this.map.equals(other);
    }

    @Override
    public Collection<V> values() {
        return new ValuesWrapper(this.map.values());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private class IteratorWrapper<E>
    implements Iterator<E> {
        private Iterator<E> it;

        public IteratorWrapper(Iterator<E> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
            ModificationAwareMap.this.onModification();
        }
    }

    private class ValuesWrapper
    extends AbstractCollection<V> {
        private Collection<V> values;

        public ValuesWrapper(Collection<V> values) {
            this.values = values;
        }

        @Override
        public Iterator<V> iterator() {
            return new IteratorWrapper(this.values.iterator());
        }

        @Override
        public int size() {
            return ModificationAwareMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ModificationAwareMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ModificationAwareMap.this.clear();
        }
    }

    private class SetWrapper<E>
    extends AbstractSet<E> {
        private Set<E> set;

        public SetWrapper(Set<E> set) {
            this.set = set;
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorWrapper<E>(this.set.iterator());
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public int size() {
            return ModificationAwareMap.this.size();
        }

        @Override
        public void clear() {
            ModificationAwareMap.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            boolean result = this.set.remove(o);
            if (result) {
                ModificationAwareMap.this.onModification();
            }
            return result;
        }
    }
}

