/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.changesets.Changeset;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.LatLon;
import de.westnordost.osmapi.map.data.Node;
import de.westnordost.osmapi.map.data.OsmElement;
import de.westnordost.osmapi.map.data.OsmLatLon;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;

public class OsmNode
extends OsmElement
implements Node,
Serializable {
    private static final long serialVersionUID = 2L;
    private boolean modified;
    private LatLon pos;

    public OsmNode(long id, int version, Double lat, Double lon, Map<String, String> tags, Changeset changeset, Instant editedAt) {
        super(id, version, tags, changeset, editedAt);
        if (lat != null && lon != null) {
            this.pos = new OsmLatLon(lat.doubleValue(), lon.doubleValue());
        }
    }

    public OsmNode(long id, int version, LatLon pos, Map<String, String> tags, Changeset changeset, Instant editedAt) {
        super(id, version, tags, changeset, editedAt);
        this.pos = pos;
    }

    public OsmNode(long id, int version, Double lat, Double lon, Map<String, String> tags) {
        this(id, version, lat, lon, tags, null, null);
    }

    public OsmNode(long id, int version, LatLon pos, Map<String, String> tags) {
        this(id, version, pos, tags, null, null);
    }

    @Override
    public LatLon getPosition() {
        return this.pos;
    }

    public void setPosition(LatLon pos) {
        this.pos = pos;
        this.modified = true;
    }

    @Override
    public boolean isModified() {
        return this.modified || super.isModified();
    }

    @Override
    public Element.Type getType() {
        return Element.Type.NODE;
    }
}

