/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.changesets.Changeset;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.ModificationAwareList;
import de.westnordost.osmapi.map.data.OsmElement;
import de.westnordost.osmapi.map.data.Relation;
import de.westnordost.osmapi.map.data.RelationMember;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class OsmRelation
extends OsmElement
implements Relation,
Serializable {
    private static final long serialVersionUID = 2L;
    private final ModificationAwareList<RelationMember> members;

    public OsmRelation(long id, int version, List<RelationMember> members, Map<String, String> tags, Changeset changeset, Instant editedAt) {
        super(id, version, tags, changeset, editedAt);
        this.members = new ModificationAwareList<RelationMember>(members);
    }

    public OsmRelation(long id, int version, List<RelationMember> members, Map<String, String> tags) {
        this(id, version, members, tags, null, null);
    }

    @Override
    public List<RelationMember> getMembers() {
        return this.members;
    }

    @Override
    public Element.Type getType() {
        return Element.Type.RELATION;
    }

    @Override
    public boolean isModified() {
        if (this.members.isModified()) {
            return true;
        }
        for (RelationMember member : this.members) {
            if (!member.isModified()) continue;
            return true;
        }
        return super.isModified();
    }
}

