/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.RelationMember;
import java.io.Serializable;

public class OsmRelationMember
implements RelationMember,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean modified;
    private final long ref;
    private final Element.Type type;
    private String role;

    public OsmRelationMember(long ref, String role, Element.Type type) {
        this.checkRoleLength(role);
        this.ref = ref;
        this.role = role;
        this.type = type;
    }

    @Override
    public long getRef() {
        return this.ref;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public Element.Type getType() {
        return this.type;
    }

    public void setRole(String newRole) {
        this.checkRoleLength(newRole);
        if (!this.role.equals(newRole)) {
            this.modified = true;
            this.role = newRole;
        }
    }

    private void checkRoleLength(String r) {
        if (r.length() >= 256) {
            throw new IllegalArgumentException("Role \"" + r + "\": Role length is limitedto less than 256 characters.");
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof RelationMember)) {
            return false;
        }
        RelationMember otherMember = (RelationMember)other;
        return this.getRole().equals(otherMember.getRole()) && this.getRef() == otherMember.getRef() && this.getType() == otherMember.getType();
    }

    public int hashCode() {
        int result = 11;
        result = 31 * result + this.role.hashCode();
        result = 31 * result + this.type.ordinal();
        result = 31 * result + (int)(this.ref ^ this.ref >>> 32);
        return result;
    }
}

