/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmapi.map.data;

import de.westnordost.osmapi.changesets.Changeset;
import de.westnordost.osmapi.map.data.Element;
import de.westnordost.osmapi.map.data.ModificationAwareList;
import de.westnordost.osmapi.map.data.OsmElement;
import de.westnordost.osmapi.map.data.Way;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class OsmWay
extends OsmElement
implements Way,
Serializable {
    private static final long serialVersionUID = 2L;
    private final ModificationAwareList<Long> nodes;

    public OsmWay(long id, int version, List<Long> nodes, Map<String, String> tags, Changeset changeset, Instant editedAt) {
        super(id, version, tags, changeset, editedAt);
        this.nodes = new ModificationAwareList<Long>(nodes);
    }

    public OsmWay(long id, int version, List<Long> nodes, Map<String, String> tags) {
        this(id, version, nodes, tags, null, null);
    }

    @Override
    public boolean isModified() {
        return this.nodes.isModified() || super.isModified();
    }

    public boolean isClosed() {
        return this.nodes.size() >= 3 && this.nodes.get(0).equals(this.nodes.get(this.nodes.size() - 1));
    }

    @Override
    public List<Long> getNodeIds() {
        return this.nodes;
    }

    @Override
    public Element.Type getType() {
        return Element.Type.WAY;
    }
}

